/*
 * Decompiled with CFR 0.152.
 */
package soba.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soba.core.ClassHierarchy;
import soba.core.ClassInfo;
import soba.core.IClassFilter;
import soba.util.files.IClassList;
import soba.util.files.IClassListCallback;

public class JavaProgram {
    private Map<String, ClassInfo> classes = new HashMap<String, ClassInfo>(65536);
    private ClassHierarchy classHierarchy;
    private List<ClassInfo> loaded;
    private List<ClassInfo> duplicated;
    private List<String> filtered;
    private List<ErrorMessage> errors = new ArrayList<ErrorMessage>(1024);

    public JavaProgram(IClassList[] lists) {
        this(lists, null);
    }

    public JavaProgram(IClassList[] lists, final IClassFilter filter) {
        this.loaded = new ArrayList<ClassInfo>(65536);
        this.duplicated = new ArrayList<ClassInfo>(1024);
        this.filtered = new ArrayList<String>(1024);
        this.classHierarchy = new ClassHierarchy();
        IClassList[] iClassListArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            final IClassList list = iClassListArray[n2];
            if (list != null) {
                list.process(new IClassListCallback(){

                    @Override
                    public boolean reportError(String name, Exception e) {
                        JavaProgram.this.errors.add(new ErrorMessage(name, e));
                        return false;
                    }

                    @Override
                    public void process(String name, InputStream stream) throws IOException {
                        if (filter == null || filter.loadClass(name)) {
                            ClassInfo c = new ClassInfo(name, stream, list.getLabel());
                            if (filter == null || filter.acceptClass(c)) {
                                if (!JavaProgram.this.classes.containsKey(c.getClassName())) {
                                    JavaProgram.this.classes.put(c.getClassName(), c);
                                    JavaProgram.this.loaded.add(c);
                                    JavaProgram.this.classHierarchy.registerClass(c);
                                } else {
                                    JavaProgram.this.duplicated.add(c);
                                }
                            } else {
                                JavaProgram.this.filtered.add(name);
                            }
                        } else {
                            JavaProgram.this.filtered.add(name);
                        }
                    }

                    @Override
                    public boolean isTarget(String name) {
                        return name.endsWith(".class");
                    }
                });
            }
            ++n2;
        }
    }

    public List<ClassInfo> getClasses() {
        return this.loaded;
    }

    public List<String> getFiltered() {
        return this.filtered;
    }

    public List<ClassInfo> getDuplicated() {
        return this.duplicated;
    }

    public List<ClassInfo> getLibraryClasses() {
        ArrayList<ClassInfo> libs = new ArrayList<ClassInfo>();
        for (ClassInfo c : this.classes.values()) {
            if (!c.isLibrary()) continue;
            libs.add(c);
        }
        return libs;
    }

    public ClassInfo getClassInfo(String className) {
        return this.classes.get(className);
    }

    public ClassHierarchy getClassHierarchy() {
        return this.classHierarchy;
    }

    public List<ErrorMessage> getErrors() {
        return this.errors;
    }

    public static class ErrorMessage {
        private String dataName;
        private Exception exception;

        public ErrorMessage(String name, Exception e) {
            this.dataName = name;
            this.exception = e;
        }

        public String getDataName() {
            return this.dataName;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

