/*
 * Decompiled with CFR 0.152.
 */
package soba.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import soba.core.ClassInfo;
import soba.core.ExampleProgram;
import soba.core.JavaProgram;
import soba.core.JavaProgramTest;
import soba.core.MethodInfo;
import soba.util.UtilForAssertThat;
import soba.util.graph.DirectedGraph;

public class MethodInfoTest
implements ExampleProgram {
    private static JavaProgram program;

    @BeforeClass
    public static void readExampleProgram() {
        program = JavaProgramTest.readExampleProgram();
    }

    @Test
    public void testMethodInfo01() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance1/D");
        MethodInfo m = c.findMethod("example", "(IJDLjava/lang/String;)I");
        Assert.assertThat((Object)m.getPackageName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1"));
        Assert.assertThat((Object)m.getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/D"));
        Assert.assertThat((Object)m.getMethodName(), (Matcher)Matchers.is((Object)"example"));
        Assert.assertThat((Object)m.getDescriptor(), (Matcher)Matchers.is((Object)"(IJDLjava/lang/String;)I"));
        Assert.assertThat((Object)m.getGenericsSignature(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)m.hasMethodBody(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)m.isLibrary(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isPrivate(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isPublic(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)m.isProtected(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isStatic(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isSynthetic(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isOverridable(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)m.isPackagePrivate(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.getInstructionCount(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)m.getParamCount(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)m.getReturnType(), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)m.getReceiverObjectParamIndex(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)m.getParamName(0), (Matcher)Matchers.is((Object)"this"));
        Assert.assertThat((Object)m.getParamName(1), (Matcher)Matchers.is((Object)"i"));
        Assert.assertThat((Object)m.getParamName(2), (Matcher)Matchers.is((Object)"l"));
        Assert.assertThat((Object)m.getParamName(3), (Matcher)Matchers.is((Object)"d"));
        Assert.assertThat((Object)m.getParamName(4), (Matcher)Matchers.is((Object)"s"));
        Assert.assertThat((Object)m.getParamName(5), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)m.getParamType(0), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/D"));
        Assert.assertThat((Object)m.getParamType(1), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)m.getParamType(2), (Matcher)Matchers.is((Object)"long"));
        Assert.assertThat((Object)m.getParamType(3), (Matcher)Matchers.is((Object)"double"));
        Assert.assertThat((Object)m.getParamType(4), (Matcher)Matchers.is((Object)"java/lang/String"));
        Assert.assertThat((Object)m.getVariableTableIndexOfParamAt(0), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)m.getVariableTableIndexOfParamAt(1), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)m.getVariableTableIndexOfParamAt(2), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)m.getVariableTableIndexOfParamAt(3), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)m.getVariableTableIndexOfParamAt(4), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)m.isParameterOrderingNumber(0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)m.getParameterOrderingNumber(0), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)m.getMaxLine(), (Matcher)Matchers.is((Object)49));
        Assert.assertThat((Object)m.getMinLine(), (Matcher)Matchers.is((Object)49));
        Assert.assertThat((Object)UtilForAssertThat.asIntegerArray(m.getLineNumbers()), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new Integer[]{49})));
        Assert.assertThat((Object)m.getLine(2), (Matcher)Matchers.is((Object)49));
        Assert.assertThat((Object)UtilForAssertThat.asIntegerArray(m.getInstructions(49)), (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3, 4})));
        Assert.assertThat(m.getCallSites(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)m.getCallSite(2), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat(m.getFieldAccesses(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)UtilForAssertThat.asIntegerArray(m.getReturnInstructions()), (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{3})));
        Assert.assertThat((Object)m.getDataDependence(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)m.getControlDependence(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)m.getConservativeControlFlow(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        DirectedGraph cfg = m.getControlFlow();
        Assert.assertThat((Object)cfg.getVertexCount(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)cfg.getEdgeCount(), (Matcher)Matchers.is((Object)3));
        Integer[] edges0 = UtilForAssertThat.asIntegerArray(cfg.getEdges(0));
        Integer[] edges1 = UtilForAssertThat.asIntegerArray(cfg.getEdges(1));
        Integer[] edges2 = UtilForAssertThat.asIntegerArray(cfg.getEdges(2));
        Integer[] edges3 = UtilForAssertThat.asIntegerArray(cfg.getEdges(3));
        Integer[] edges4 = UtilForAssertThat.asIntegerArray(cfg.getEdges(4));
        Assert.assertThat((Object)edges0, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1})));
        Assert.assertThat((Object)edges1, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{2})));
        Assert.assertThat((Object)edges2, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{3})));
        Assert.assertThat((Object)edges3, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edges4, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)m.getMethodKey(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/D#example#(IJDLjava/lang/String;)I"));
        Assert.assertThat((Object)m.toLongString(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/D.example(soba/testdata/inheritance1/D:this, int:i, long:l, double:d, java/lang/String:s): int"));
        Assert.assertThat((Object)m.getInstructionString(0), (Matcher)Matchers.is((Object)"0: (L00000)"));
        Assert.assertThat((Object)m.getInstructionString(1), (Matcher)Matchers.is((Object)"1: (line=49)"));
        Assert.assertThat((Object)m.getInstructionString(2), (Matcher)Matchers.is((Object)"2: ILOAD 1 (i)"));
        Assert.assertThat((Object)m.getInstructionString(3), (Matcher)Matchers.is((Object)"3: IRETURN"));
        Assert.assertThat((Object)m.getInstructionString(4), (Matcher)Matchers.is((Object)"4: (L00004)"));
    }

    @Test
    public void testMethodInfo02() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance1/C");
        MethodInfo m = c.findMethod("main", "([Ljava/lang/String;)V");
        Assert.assertThat((Object)m.getPackageName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1"));
        Assert.assertThat((Object)m.getClassName(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/C"));
        Assert.assertThat((Object)m.getMethodName(), (Matcher)Matchers.is((Object)"main"));
        Assert.assertThat((Object)m.getDescriptor(), (Matcher)Matchers.is((Object)"([Ljava/lang/String;)V"));
        Assert.assertThat((Object)m.getGenericsSignature(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)m.hasMethodBody(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)m.isLibrary(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isPrivate(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isPublic(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)m.isProtected(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isStatic(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)m.isSynthetic(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isOverridable(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.isPackagePrivate(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)m.getInstructionCount(), (Matcher)Matchers.is((Object)27));
        Assert.assertThat((Object)m.getParamCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)m.getReturnType(), (Matcher)Matchers.is((Object)"void"));
        Assert.assertThat((Object)m.getParamName(0), (Matcher)Matchers.is((Object)"args"));
        Assert.assertThat((Object)m.getParamType(0), (Matcher)Matchers.is((Object)"java/lang/String[]"));
        Assert.assertThat((Object)m.getVariableTableIndexOfParamAt(0), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)m.isParameterOrderingNumber(0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)m.getParameterOrderingNumber(0), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)m.getMaxLine(), (Matcher)Matchers.is((Object)15));
        Assert.assertThat((Object)m.getMinLine(), (Matcher)Matchers.is((Object)10));
        Assert.assertThat((Object)UtilForAssertThat.asIntegerArray(m.getLineNumbers()), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new Integer[]{10, 11, 12, 13, 14, 15})));
        Assert.assertThat((Object)m.getLine(9), (Matcher)Matchers.is((Object)11));
        Assert.assertThat((Object)UtilForAssertThat.asIntegerArray(m.getInstructions(11)), (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{6, 7, 8, 9, 10, 11})));
        Assert.assertThat(m.getCallSites(), (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)m.getCallSite(9), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat(m.getFieldAccesses(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)UtilForAssertThat.asIntegerArray(m.getReturnInstructions()), (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{25})));
        Assert.assertThat((Object)m.getDataDependence(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)m.getControlDependence(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)m.getConservativeControlFlow(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)m.getControlFlow(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)m.getMethodKey(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/C#main#([Ljava/lang/String;)V"));
        Assert.assertThat((Object)m.toLongString(), (Matcher)Matchers.is((Object)"soba/testdata/inheritance1/C.main(java/lang/String[]:args): void"));
    }
}

