/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

import soba.core.MethodInfo;

public class CallSite {
    private MethodInfo ownerMethod;
    private int instructionIndex;
    private String className;
    private String methodName;
    private String methodDesc;
    private Kind invokeType;

    public CallSite(MethodInfo m, int instIndex, String className, String methodName, String methodDesc, Kind kind) {
        this.ownerMethod = m;
        this.instructionIndex = instIndex;
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.invokeType = kind;
    }

    public MethodInfo getOwnerMethod() {
        return this.ownerMethod;
    }

    public int getInstructionIndex() {
        return this.instructionIndex;
    }

    public boolean isStaticOrSpecial() {
        return this.invokeType != Kind.VIRTUAL;
    }

    public boolean isStaticMethod() {
        return this.invokeType == Kind.STATIC;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDescriptor() {
        return this.methodDesc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.className);
        sb.append(".");
        sb.append(this.methodName);
        sb.append(this.methodDesc);
        sb.append(" called by ");
        sb.append(this.ownerMethod.toLongString());
        return sb.toString();
    }

    public static enum Kind {
        STATIC,
        SPECIAL,
        VIRTUAL;

    }
}

