/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import soba.core.method.ControlDependence;
import soba.util.IntPairList;
import soba.util.UtilForAssertThat;
import soba.util.graph.DirectedGraph;

public class ControlDependenceTest {
    public static DirectedGraph buildControlFlowGraph() {
        IntPairList edges = new IntPairList();
        edges.add(0, 1);
        edges.add(1, 2);
        edges.add(2, 0);
        edges.add(1, 3);
        edges.add(3, 4);
        edges.add(3, 5);
        edges.add(5, 6);
        edges.add(6, 8);
        edges.add(8, 5);
        edges.add(6, 7);
        edges.add(7, 9);
        edges.add(7, 10);
        edges.add(9, 11);
        edges.add(10, 11);
        edges.add(11, 12);
        return new DirectedGraph(14, edges);
    }

    @Test
    public void testControlDependence() {
        DirectedGraph g = ControlDependenceTest.buildControlFlowGraph();
        DirectedGraph cd = ControlDependence.getDependence(14, g);
        Integer[] edgesFrom0 = UtilForAssertThat.asIntegerArray(cd.getEdges(0));
        Integer[] edgesFrom2 = UtilForAssertThat.asIntegerArray(cd.getEdges(2));
        Integer[] edgesFrom4 = UtilForAssertThat.asIntegerArray(cd.getEdges(4));
        Integer[] edgesFrom5 = UtilForAssertThat.asIntegerArray(cd.getEdges(5));
        Integer[] edgesFrom8 = UtilForAssertThat.asIntegerArray(cd.getEdges(8));
        Integer[] edgesFrom9 = UtilForAssertThat.asIntegerArray(cd.getEdges(9));
        Integer[] edgesFrom10 = UtilForAssertThat.asIntegerArray(cd.getEdges(10));
        Integer[] edgesFrom11 = UtilForAssertThat.asIntegerArray(cd.getEdges(11));
        Integer[] edgesFrom12 = UtilForAssertThat.asIntegerArray(cd.getEdges(12));
        Integer[] edgesFrom13 = UtilForAssertThat.asIntegerArray(cd.getEdges(13));
        Assert.assertThat((Object)edgesFrom0, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom2, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom4, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom5, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom8, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom9, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom10, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom11, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom12, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)edgesFrom13, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Integer[] edgesFrom1 = UtilForAssertThat.asIntegerArray(cd.getEdges(1));
        Integer[] edgesFrom3 = UtilForAssertThat.asIntegerArray(cd.getEdges(3));
        Integer[] edgesFrom6 = UtilForAssertThat.asIntegerArray(cd.getEdges(6));
        Integer[] edgesFrom7 = UtilForAssertThat.asIntegerArray(cd.getEdges(7));
        Assert.assertThat((Object)edgesFrom1, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{0, 2})));
        Assert.assertThat((Object)edgesFrom3, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{4, 6, 7, 11, 12})));
        Assert.assertThat((Object)edgesFrom6, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{5, 8})));
        Assert.assertThat((Object)edgesFrom7, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{9, 10})));
    }
}

