/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.Frame;
import soba.core.method.DataFlowEdge;
import soba.core.method.LocalVariables;
import soba.core.method.OpcodeString;
import soba.core.method.asm.DataFlowAnalyzer;
import soba.core.method.asm.FastSourceValue;
import soba.util.IntPairList;
import soba.util.ObjectIdMap;
import soba.util.graph.DirectedGraph;

public class DataDependence {
    private ObjectIdMap<AbstractInsnNode> instructions;
    private DataFlowAnalyzer analyzer;
    private LocalVariables locals;
    private List<DataFlowEdge> dataFlowEdges;
    private List<DataFlowEdge> dataFlowEdgesSourceOrder;

    public DataDependence(ObjectIdMap<AbstractInsnNode> instructions, DataFlowAnalyzer analyzer) {
        this.instructions = instructions;
        this.analyzer = analyzer;
        this.computeEdges();
    }

    public DirectedGraph getDependenceGraph() {
        IntPairList edges = new IntPairList(this.dataFlowEdges.size());
        for (DataFlowEdge e : this.dataFlowEdges) {
            if (e.getSourceInstruction() == -1) continue;
            edges.add(e.getSourceInstruction(), e.getDestinationInstruction());
        }
        return new DirectedGraph(this.instructions.size(), edges);
    }

    public List<DataFlowEdge> getEdges() {
        return this.dataFlowEdges;
    }

    public List<DataFlowEdge> getEdgesInSourceOrder() {
        return this.dataFlowEdgesSourceOrder;
    }

    public LocalVariables getLocalVariables() {
        if (this.locals == null) {
            this.locals = new LocalVariables(this, this.analyzer.getAnalyzedMethod());
        }
        return this.locals;
    }

    public String getVariableName(DataFlowEdge e) {
        LocalVariables locals = this.getLocalVariables();
        if (e.isLocal()) {
            int sourceIndex;
            String sourceName;
            if (e.getSourceInstruction() != -1 && (sourceName = locals.getVariableName(sourceIndex = locals.findEntryForInstruction(e.getSourceInstruction()))) != null) {
                return sourceName;
            }
            int destinationIndex = locals.findEntryForInstruction(e.getDestinationInstruction());
            String destinationName = locals.getVariableName(destinationIndex);
            if (destinationName == null) {
                return String.valueOf(e.getVariableIndex()) + "_unavailable";
            }
            return destinationName;
        }
        return null;
    }

    public String getVariableDescriptor(DataFlowEdge e) {
        LocalVariables locals = this.getLocalVariables();
        if (e.isLocal()) {
            int sourceIndex;
            String sourceDescriptor;
            if (e.getSourceInstruction() != -1 && (sourceDescriptor = locals.getDescriptor(sourceIndex = locals.findEntryForInstruction(e.getSourceInstruction()))) != null) {
                return sourceDescriptor;
            }
            int destinationIndex = locals.findEntryForInstruction(e.getDestinationInstruction());
            String destinationDescriptor = locals.getDescriptor(destinationIndex);
            if (destinationDescriptor == null) {
                return "null";
            }
            return destinationDescriptor;
        }
        return null;
    }

    public int[][] getDataDefinition(int instructionIndex) {
        if (this.useStack(instructionIndex)) {
            int operands = this.analyzer.getOperandCount(instructionIndex);
            int[][] operandDef = new int[operands][];
            int i = 0;
            while (i < operands) {
                Frame f = this.analyzer.getFrames()[instructionIndex];
                FastSourceValue value = (FastSourceValue)f.getStack(f.getStackSize() - operands + i);
                operandDef[i] = value.getInstructions();
                ++i;
            }
            return operandDef;
        }
        AbstractInsnNode to = this.instructions.getItem(instructionIndex);
        if (this.referLocal(instructionIndex)) {
            int localIndex = OpcodeString.getVarIndex(to);
            Frame f = this.analyzer.getFrames()[instructionIndex];
            if (f != null) {
                FastSourceValue value = (FastSourceValue)f.getLocal(localIndex);
                int[][] localDef = new int[][]{value.getInstructions()};
                return localDef;
            }
            return new int[0][0];
        }
        return new int[0][];
    }

    public List<DataFlowEdge> getIncomingEdges(int destinationInstruction) {
        ArrayList<DataFlowEdge> edges = new ArrayList<DataFlowEdge>();
        for (DataFlowEdge e : this.dataFlowEdges) {
            if (e.getDestinationInstruction() != destinationInstruction) continue;
            edges.add(e);
        }
        return edges;
    }

    public DataFlowEdge getIncomingEdge(int destinationInstruction, int operandIndex) {
        for (DataFlowEdge dfe : this.dataFlowEdges) {
            if (dfe.getDestinationInstruction() != destinationInstruction || dfe.getDestinationOperandIndex() != operandIndex) continue;
            return dfe;
        }
        throw new UnsupportedOperationException();
    }

    public List<DataFlowEdge> getIncomingEdges(int destinationInstruction, int operandIndex) {
        ArrayList<DataFlowEdge> edges = new ArrayList<DataFlowEdge>();
        for (DataFlowEdge e : this.dataFlowEdges) {
            if (e.getDestinationInstruction() != destinationInstruction || e.getDestinationOperandIndex() != operandIndex) continue;
            edges.add(e);
        }
        return edges;
    }

    private void computeEdges() {
        ArrayList<DataFlowEdge> edges = new ArrayList<DataFlowEdge>();
        int instructionIndex = 0;
        while (instructionIndex < this.instructions.size()) {
            int n;
            Frame f = this.analyzer.getFrames()[instructionIndex];
            if (this.useStack(instructionIndex)) {
                int operands = this.analyzer.getOperandCount(instructionIndex);
                int opIndex = 0;
                while (opIndex < operands) {
                    int stackPos = f.getStackSize() - operands + opIndex;
                    FastSourceValue value = (FastSourceValue)f.getStack(stackPos);
                    int[] nArray = value.getInstructions();
                    int n2 = nArray.length;
                    n = 0;
                    while (n < n2) {
                        int from = nArray[n];
                        edges.add(new DataFlowEdge(from, instructionIndex, opIndex, operands, stackPos, false));
                        ++n;
                    }
                    ++opIndex;
                }
            } else if (this.referLocal(instructionIndex)) {
                AbstractInsnNode to = this.instructions.getItem(instructionIndex);
                int localIndex = OpcodeString.getVarIndex(to);
                if (f != null) {
                    FastSourceValue value = (FastSourceValue)f.getLocal(localIndex);
                    int[] nArray = value.getInstructions();
                    n = nArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int from = nArray[n3];
                        edges.add(new DataFlowEdge(from, instructionIndex, 0, 1, localIndex, true));
                        ++n3;
                    }
                }
            }
            ++instructionIndex;
        }
        ArrayList<DataFlowEdge> sourceOrder = new ArrayList<DataFlowEdge>(edges.size());
        sourceOrder.addAll(edges);
        Collections.sort(sourceOrder, new DataFlowEdge.SourceComparator());
        this.dataFlowEdgesSourceOrder = sourceOrder;
        this.dataFlowEdges = edges;
    }

    public boolean useStack(int instructionIndex) {
        return this.analyzer.getOperandCount(instructionIndex) > 0;
    }

    private boolean referLocal(int instructionIndex) {
        return OpcodeString.isLocalReferenceOperation(this.instructions.getItem(instructionIndex));
    }

    public AbstractInsnNode getInstruction(int index) {
        return this.instructions.getItem(index);
    }

    public int getOperandCount(int instructionIndex) {
        return this.analyzer.getOperandCount(instructionIndex);
    }

    public Frame<?> getFrame(int instructionIndex) {
        return this.analyzer.getFrames()[instructionIndex];
    }
}

