/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

import java.util.Comparator;

public class DataFlowEdge {
    private int from;
    private int to;
    private int operandIndex;
    private int operandCount;
    private int variableIndex;
    private boolean isLocal;

    public DataFlowEdge(int from, int to, int operandIndex, int operandCount, int variableIndex, boolean isLocal) {
        assert (operandIndex < operandCount);
        this.from = from;
        this.to = to;
        this.operandIndex = operandIndex;
        this.operandCount = operandCount;
        this.variableIndex = variableIndex;
        this.isLocal = isLocal;
    }

    public int getSourceInstruction() {
        return this.from;
    }

    public int getDestinationInstruction() {
        return this.to;
    }

    public int getDestinationOperandIndex() {
        return this.operandIndex;
    }

    public int getDestinationOperandCount() {
        return this.operandCount;
    }

    public int getVariableIndex() {
        return this.variableIndex;
    }

    public boolean isParameter() {
        return this.isLocal && this.from == -1;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        if (this.isParameter()) {
            builder.append("PARAM");
        } else {
            builder.append(this.from);
        }
        builder.append(" -> ");
        builder.append(this.to);
        if (this.operandCount > 1) {
            builder.append(" [");
            builder.append(this.operandIndex + 1);
            builder.append("/");
            builder.append(this.operandCount);
            builder.append("]");
        }
        if (this.isLocal) {
            builder.append(" (LOCAL:");
        } else {
            builder.append(" (STACK:");
        }
        builder.append(this.variableIndex);
        builder.append(")");
        return builder.toString();
    }

    private static int compareVariable(DataFlowEdge o1, DataFlowEdge o2) {
        if (o1.operandIndex == o2.operandIndex) {
            if (o1.variableIndex == o2.variableIndex) {
                if (o1.isLocal == o2.isLocal) {
                    return 0;
                }
                if (o1.isLocal) {
                    return 1;
                }
                return -1;
            }
            return o1.variableIndex - o2.variableIndex;
        }
        return o1.operandIndex - o2.operandIndex;
    }

    public static class DestinationComparator
    implements Comparator<DataFlowEdge> {
        @Override
        public int compare(DataFlowEdge o1, DataFlowEdge o2) {
            if (o1.to == o2.to) {
                if (o1.from == o2.from) {
                    return DataFlowEdge.compareVariable(o1, o2);
                }
                return o1.from - o2.from;
            }
            return o1.to - o2.to;
        }
    }

    public static class SourceComparator
    implements Comparator<DataFlowEdge> {
        @Override
        public int compare(DataFlowEdge o1, DataFlowEdge o2) {
            if (o1.from == o2.from) {
                if (o1.to == o2.to) {
                    return DataFlowEdge.compareVariable(o1, o2);
                }
                return o1.to - o2.to;
            }
            return o1.from - o2.from;
        }
    }
}

