/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

public class FieldAccess {
    private String className;
    private String fieldName;
    private String fieldDesc;
    private boolean isStatic;
    private boolean isGet;

    private FieldAccess(String className, String fieldName, String fieldDesc, boolean isStatic, boolean isGet) {
        this.className = className;
        this.fieldName = fieldName;
        this.fieldDesc = fieldDesc;
        this.isStatic = isStatic;
        this.isGet = isGet;
    }

    public static FieldAccess createGetField(String className, String fieldName, String fieldDesc, boolean isStatic) {
        return new FieldAccess(className, fieldName, fieldDesc, isStatic, true);
    }

    public static FieldAccess createPutField(String className, String fieldName, String fieldDesc, boolean isStatic) {
        return new FieldAccess(className, fieldName, fieldDesc, isStatic, false);
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDescriptor() {
        return this.fieldDesc;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isGet() {
        return this.isGet;
    }

    public boolean isPut() {
        return !this.isGet;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isGet) {
            b.append("GET");
        } else {
            b.append("PUT");
        }
        if (this.isStatic) {
            b.append("STATIC");
        } else {
            b.append("FIELD");
        }
        b.append(" ");
        b.append(this.className);
        b.append(".");
        b.append(this.fieldName);
        b.append(": ");
        b.append(this.fieldDesc);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        FieldAccess fa = (FieldAccess)obj;
        return this.toString().equals(fa.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.fieldDesc == null ? 0 : this.fieldDesc.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.isGet ? 1231 : 1237);
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        return result;
    }
}

