/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.objectweb.asm.tree.InsnList;
import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.JavaProgramTest;
import soba.core.MethodInfo;
import soba.core.method.LocalVariables;

public class LocalVariablesTest {
    private static JavaProgram program;
    private static ClassInfo c;
    private static LocalVariables variables;
    private static InsnList instructions;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        program = JavaProgramTest.readExampleProgram();
        c = program.getClassInfo("soba/testdata/DefUseTestData");
        MethodInfo m = c.findMethod("localDataDependence", "()V");
        instructions = m.getMethodNode().instructions;
        variables = new LocalVariables(m.getDataDependence(), m.getMethodNode());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetVariableEntryCount() {
        Assert.assertThat((Object)variables.getVariableEntryCount(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testGetVariableName() {
        Assert.assertThat((Object)variables.getVariableName(0), (Matcher)Matchers.is((Object)"b"));
        Assert.assertThat((Object)variables.getVariableName(1), (Matcher)Matchers.is((Object)"x"));
        Assert.assertThat((Object)variables.getVariableName(2), (Matcher)Matchers.is((Object)"x"));
    }

    @Test
    public void testGetVariableType() {
        Assert.assertThat((Object)variables.getVariableType(0), (Matcher)Matchers.is((Object)"boolean"));
        Assert.assertThat((Object)variables.getVariableType(1), (Matcher)Matchers.is((Object)"int"));
        Assert.assertThat((Object)variables.getVariableType(2), (Matcher)Matchers.is((Object)"int"));
    }

    @Test
    public void testGetVariableIndex() {
        Assert.assertThat((Object)variables.getVariableIndex(0), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)variables.getVariableIndex(1), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)variables.getVariableIndex(2), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testIsObjectVariable() {
        Assert.assertThat((Object)variables.isObjectVariable(0), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)variables.isObjectVariable(1), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)variables.isObjectVariable(2), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsArrayVariable() {
        Assert.assertThat((Object)variables.isArrayVariable(0), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)variables.isArrayVariable(1), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)variables.isArrayVariable(2), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testHasNoDataDependence() {
        Assert.assertThat((Object)variables.hasNoDataDependence(0), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)variables.hasNoDataDependence(1), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)variables.hasNoDataDependence(2), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsParameter() {
        Assert.assertThat((Object)variables.isParameter(0), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)variables.isParameter(1), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)variables.isParameter(2), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testFindEntryForInstruction() {
        int storeCount = 0;
        int loadCount = 0;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 54) {
                if (storeCount == 0) {
                    Assert.assertThat((Object)variables.findEntryForInstruction(i), (Matcher)Matchers.is((Object)0));
                } else if (storeCount == 1 || storeCount == 3) {
                    Assert.assertThat((Object)variables.findEntryForInstruction(i), (Matcher)Matchers.is((Object)2));
                } else {
                    Assert.assertThat((Object)variables.findEntryForInstruction(i), (Matcher)Matchers.is((Object)1));
                }
                ++storeCount;
            } else if (instructions.get(i).getOpcode() == 21) {
                if (loadCount == 0) {
                    Assert.assertThat((Object)variables.findEntryForInstruction(i), (Matcher)Matchers.is((Object)0));
                } else if (loadCount == 1) {
                    Assert.assertThat((Object)variables.findEntryForInstruction(i), (Matcher)Matchers.is((Object)1));
                } else {
                    Assert.assertThat((Object)variables.findEntryForInstruction(i), (Matcher)Matchers.is((Object)2));
                }
                ++loadCount;
            } else {
                Assert.assertThat((Object)variables.findEntryForInstruction(i), (Matcher)Matchers.is((Object)-1));
            }
            ++i;
        }
    }
}

