/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method.asm;

import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;
import soba.core.method.asm.DataFlowInterpreter;
import soba.util.IntPairList;
import soba.util.IntPairSet;
import soba.util.IntPairUtil;

public class DataFlowAnalyzer
extends Analyzer<Value> {
    private MethodNode method;
    private IntPairSet controlFlow = new IntPairSet();
    private IntPairSet exceptionalFlow = new IntPairSet();
    private DataFlowInterpreter interpreter;

    public DataFlowAnalyzer(DataFlowInterpreter interpreter) {
        super((Interpreter)interpreter);
        this.interpreter = interpreter;
    }

    public Frame<Value>[] analyze(String owner, MethodNode m) throws AnalyzerException {
        this.method = m;
        return super.analyze(owner, m);
    }

    protected void newControlFlowEdge(int insn, int successor) {
        this.controlFlow.add(insn, successor);
        super.newControlFlowEdge(insn, successor);
    }

    protected boolean newControlFlowExceptionEdge(int insn, int successor) {
        this.exceptionalFlow.add(insn, successor);
        return super.newControlFlowExceptionEdge(insn, successor);
    }

    public MethodNode getAnalyzedMethod() {
        return this.method;
    }

    public IntPairList getNormalControlFlow() {
        return IntPairUtil.createList(this.controlFlow);
    }

    public IntPairList getConservativeControlFlow() {
        return IntPairUtil.createList(this.controlFlow, this.exceptionalFlow);
    }

    public int getOperandCount(int instructionIndex) {
        return this.interpreter.getOperandCount(instructionIndex);
    }
}

