/*
 * Decompiled with CFR 0.152.
 */
package soba.core.method.asm;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import soba.core.method.asm.FastSourceValue;
import soba.util.UtilForAssertThat;

public class FastSourceValueTest {
    @Test
    public void testConstructorWithoutInstruction() {
        FastSourceValue value1 = new FastSourceValue(1);
        Assert.assertThat((Object)value1.getSize(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)value1.getInstructions().length, (Matcher)Matchers.is((Object)0));
        FastSourceValue value2 = new FastSourceValue(2);
        Assert.assertThat((Object)value2.getSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)value2.getInstructions().length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testConstructorWithSingleInstruction() {
        FastSourceValue value1 = new FastSourceValue(1, 2);
        Assert.assertThat((Object)value1.getSize(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)value1.getInstructions().length, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)value1.getInstructions()[0], (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testConstructorWithArray() {
        FastSourceValue value1 = new FastSourceValue(2, new int[]{1, 4, 9});
        Assert.assertThat((Object)value1.getSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)value1.getInstructions().length, (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)value1.getInstructions()[0], (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)value1.getInstructions()[1], (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)value1.getInstructions()[2], (Matcher)Matchers.is((Object)9));
    }

    @Test
    public void testMerge() {
        FastSourceValue value123 = new FastSourceValue(1, new int[]{1, 2, 3});
        FastSourceValue value456 = new FastSourceValue(1, new int[]{4, 5, 6});
        FastSourceValue value135 = new FastSourceValue(1, new int[]{1, 3, 5});
        FastSourceValue value246 = new FastSourceValue(1, new int[]{2, 4, 6});
        FastSourceValue valueNULL = new FastSourceValue(1, new int[0]);
        FastSourceValue value123Size2 = new FastSourceValue(2, new int[]{1, 2, 3});
        FastSourceValue value123456concat = new FastSourceValue(value123, value456);
        Integer[] instructions123456 = UtilForAssertThat.asIntegerArray(value123456concat.getInstructions());
        Assert.assertThat((Object)instructions123456, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3, 4, 5, 6})));
        FastSourceValue value123456anotherConcat = new FastSourceValue(value456, value123);
        Integer[] instructions123456another = UtilForAssertThat.asIntegerArray(value123456anotherConcat.getInstructions());
        Assert.assertThat((Object)instructions123456another, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3, 4, 5, 6})));
        FastSourceValue value123456mix = new FastSourceValue(value135, value246);
        Integer[] instructions123456mix = UtilForAssertThat.asIntegerArray(value123456mix.getInstructions());
        Assert.assertThat((Object)instructions123456mix, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3, 4, 5, 6})));
        FastSourceValue value123456anotherMix = new FastSourceValue(value246, value135);
        Integer[] instructions123456anotherMix = UtilForAssertThat.asIntegerArray(value123456anotherMix.getInstructions());
        Assert.assertThat((Object)instructions123456anotherMix, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3, 4, 5, 6})));
        FastSourceValue value123unchanged = new FastSourceValue(value123, valueNULL);
        Integer[] instructions123 = UtilForAssertThat.asIntegerArray(value123unchanged.getInstructions());
        Assert.assertThat((Object)instructions123, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3})));
        FastSourceValue value246unchanged = new FastSourceValue(valueNULL, value246);
        Integer[] instructions246 = UtilForAssertThat.asIntegerArray(value246unchanged.getInstructions());
        Assert.assertThat((Object)instructions246, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{2, 4, 6})));
        FastSourceValue valueConcatNull = new FastSourceValue(valueNULL, valueNULL);
        Integer[] instructionsNull = UtilForAssertThat.asIntegerArray(valueConcatNull.getInstructions());
        Assert.assertThat((Object)instructionsNull, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        FastSourceValue value1235 = new FastSourceValue(value123, value135);
        Integer[] instructions1235 = UtilForAssertThat.asIntegerArray(value1235.getInstructions());
        Assert.assertThat((Object)instructions1235, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3, 5})));
        FastSourceValue value1235another = new FastSourceValue(value135, value123);
        Integer[] instructions1235another = UtilForAssertThat.asIntegerArray(value1235another.getInstructions());
        Assert.assertThat((Object)instructions1235another, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3, 5})));
        FastSourceValue value2456 = new FastSourceValue(value246, value456);
        Integer[] instructions2456 = UtilForAssertThat.asIntegerArray(value2456.getInstructions());
        Assert.assertThat((Object)instructions2456, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{2, 4, 5, 6})));
        FastSourceValue value2456another = new FastSourceValue(value456, value246);
        Integer[] instructions2456another = UtilForAssertThat.asIntegerArray(value2456another.getInstructions());
        Assert.assertThat((Object)instructions2456another, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{2, 4, 5, 6})));
        FastSourceValue value123differentSize = new FastSourceValue(value123, value123Size2);
        Integer[] instructions123different = UtilForAssertThat.asIntegerArray(value123differentSize.getInstructions());
        Assert.assertThat((Object)instructions123different, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3})));
        Assert.assertThat((Object)value123differentSize.getSize(), (Matcher)Matchers.is((Object)1));
        FastSourceValue value123differentSizeAnother = new FastSourceValue(value123Size2, value123);
        Integer[] instructions123differentAnother = UtilForAssertThat.asIntegerArray(value123differentSizeAnother.getInstructions());
        Assert.assertThat((Object)instructions123differentAnother, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3})));
        Assert.assertThat((Object)value123differentSizeAnother.getSize(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testContainsAll() {
        FastSourceValue value123 = new FastSourceValue(1, new int[]{1, 2, 3});
        FastSourceValue value246 = new FastSourceValue(1, new int[]{2, 4, 6});
        FastSourceValue valueNULL = new FastSourceValue(1, new int[0]);
        FastSourceValue value0 = new FastSourceValue(1, 0);
        FastSourceValue value1 = new FastSourceValue(1, 1);
        FastSourceValue value2 = new FastSourceValue(1, 2);
        FastSourceValue value3 = new FastSourceValue(1, 3);
        FastSourceValue value4 = new FastSourceValue(1, 4);
        FastSourceValue value12 = new FastSourceValue(1, new int[]{1, 2});
        FastSourceValue value23 = new FastSourceValue(1, new int[]{2, 3});
        FastSourceValue value45 = new FastSourceValue(1, new int[]{4, 5});
        FastSourceValue value46 = new FastSourceValue(1, new int[]{4, 6});
        FastSourceValue value1234 = new FastSourceValue(1, new int[]{1, 2, 3, 4});
        FastSourceValue value24 = new FastSourceValue(1, new int[]{2, 4});
        Assert.assertThat((Object)value123.containsAll(valueNULL), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value123.containsAll(value123), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value123.containsAll(value1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value123.containsAll(value2), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value123.containsAll(value3), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value123.containsAll(value12), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value123.containsAll(value23), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value123.containsAll(value0), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)value123.containsAll(value4), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)value123.containsAll(value246), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)value123.containsAll(value45), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)value123.containsAll(value46), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)value123.containsAll(value1234), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)value123.containsAll(value24), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)valueNULL.containsAll(valueNULL), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)valueNULL.containsAll(value1), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)valueNULL.containsAll(value123), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)value246.containsAll(value46), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value246.containsAll(value4), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value246.containsAll(value24), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value246.containsAll(value123), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testEquals() {
        int[] v123 = new int[]{1, 2, 3};
        FastSourceValue value123 = new FastSourceValue(1, v123);
        FastSourceValue value123another = new FastSourceValue(1, v123);
        FastSourceValue value123differentSize = new FastSourceValue(2, v123);
        FastSourceValue value123differentArray = new FastSourceValue(1, new int[]{1, 2, 3});
        FastSourceValue value123differentSizeAndArray = new FastSourceValue(2, new int[]{1, 2, 3});
        Assert.assertThat((Object)value123.equals(value123another), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value123.equals(value123differentSize), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)value123.equals(value123differentArray), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)value123.equals(value123differentSizeAndArray), (Matcher)Matchers.is((Object)false));
    }
}

