/*
 * Decompiled with CFR 0.152.
 */
package soba.core.signature;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import soba.core.signature.TypeVisitor;

public class MethodSignatureReader {
    private int paramCount = 0;
    private TypeVisitor returnTypeVisitor;
    private List<TypeVisitor> exceptionTypeVisitors = new ArrayList<TypeVisitor>();
    private List<TypeVisitor> paramTypeVisitors = new ArrayList<TypeVisitor>();

    public MethodSignatureReader(String signature) {
        SignatureReader sigReader = new SignatureReader(signature);
        sigReader.accept(new SignatureVisitor(327680){

            public void visitFormalTypeParameter(String name) {
            }

            public SignatureVisitor visitParameterType() {
                MethodSignatureReader methodSignatureReader = MethodSignatureReader.this;
                methodSignatureReader.paramCount = methodSignatureReader.paramCount + 1;
                TypeVisitor param = new TypeVisitor();
                MethodSignatureReader.this.paramTypeVisitors.add(param);
                return param;
            }

            public SignatureVisitor visitReturnType() {
                MethodSignatureReader.this.returnTypeVisitor = new TypeVisitor();
                return MethodSignatureReader.this.returnTypeVisitor;
            }

            public SignatureVisitor visitExceptionType() {
                TypeVisitor exceptionTypeVisitor = new TypeVisitor();
                MethodSignatureReader.this.exceptionTypeVisitors.add(exceptionTypeVisitor);
                return exceptionTypeVisitor;
            }

            public void visitTypeVariable(String name) {
            }

            public SignatureVisitor visitTypeArgument(char wildcard) {
                return this;
            }

            public void visitTypeArgument() {
            }

            public SignatureVisitor visitSuperclass() {
                return this;
            }

            public SignatureVisitor visitInterfaceBound() {
                return this;
            }

            public SignatureVisitor visitInterface() {
                return this;
            }

            public void visitInnerClassType(String name) {
            }

            public void visitEnd() {
            }

            public void visitClassType(String name) {
            }

            public SignatureVisitor visitClassBound() {
                return this;
            }

            public void visitBaseType(char descriptor) {
            }

            public SignatureVisitor visitArrayType() {
                return null;
            }
        });
        assert (this.paramTypeVisitors.size() == this.paramCount) : "Failed to read a method signature: paramTypes=" + Integer.toString(this.paramTypeVisitors.size()) + ", paramCount=" + Integer.toString(this.paramCount);
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public String getParamType(int paramIndex) {
        return this.paramTypeVisitors.get(paramIndex).getTypeName();
    }

    public boolean isGenericType(int paramIndex) {
        return this.paramTypeVisitors.get(paramIndex).isGenericType();
    }

    public String getReturnType() {
        return this.returnTypeVisitor.getTypeName();
    }

    public boolean isGenericReturnType() {
        return this.returnTypeVisitor.isGenericType();
    }

    public int getExceptionCount() {
        return this.exceptionTypeVisitors.size();
    }

    public String getExceptionType(int exceptionIndex) {
        return this.exceptionTypeVisitors.get(exceptionIndex).getTypeName();
    }

    public boolean isGenericExceptionType(int exceptionIndex) {
        return this.exceptionTypeVisitors.get(exceptionIndex).isGenericType();
    }
}

