/*
 * Decompiled with CFR 0.152.
 */
package soba.core.signature;

public class TypeConstants {
    public static final String BOOLEAN = "boolean";
    public static final String BYTE = "byte";
    public static final String CHAR = "char";
    public static final String SHORT = "short";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String VOID = "void";
    public static final String JAVA_STRING = "java/lang/String";
    public static final String UNKNOWN_TYPE = "UNKNOWN-TYPE";
    public static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};

    public static boolean isPrimitiveTypeName(String name) {
        int i = 0;
        while (i < PRIMITIVE_TYPES.length) {
            if (PRIMITIVE_TYPES[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPrimitiveOrVoid(String name) {
        return TypeConstants.isPrimitiveTypeName(name) || VOID.equals(name);
    }

    public static boolean isVoid(String name) {
        return VOID.equals(name);
    }

    public static int getWordCount(String name) {
        if (DOUBLE.equals(name) || LONG.equals(name)) {
            return 2;
        }
        return 1;
    }

    public static boolean isJavaString(String name) {
        return name != null && name.equals(JAVA_STRING);
    }
}

