/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import soba.core.method.CallSite;
import soba.core.signature.MethodSignatureReader;
import soba.core.signature.TypeConstants;
import soba.core.vta.VTAResolver;

class CallSiteVertices {
    private int paramCount;
    private int[] paramIndex;
    private int[] vertexIDs;
    private String[] vertexTypes;
    private CallSite callsite;

    public CallSiteVertices(CallSite c, int startID) {
        this.callsite = c;
        MethodSignatureReader sig = new MethodSignatureReader(c.getDescriptor());
        this.paramCount = !c.isStaticMethod() ? sig.getParamCount() + 1 : sig.getParamCount();
        TIntArrayList params = new TIntArrayList(this.paramCount);
        ArrayList<String> types = new ArrayList<String>(this.paramCount);
        int thisCount = 0;
        if (!c.isStaticMethod()) {
            thisCount = 1;
            params.add(0);
            types.add(c.getClassName());
        }
        int i = 0;
        while (i < sig.getParamCount()) {
            String t = sig.getParamType(i);
            if (!TypeConstants.isPrimitiveOrVoid(t)) {
                params.add(i + thisCount);
                types.add(String.valueOf(t) + thisCount);
            }
            ++i;
        }
        if (!TypeConstants.isPrimitiveOrVoid(sig.getReturnType())) {
            params.add(this.paramCount);
            types.add(sig.getReturnType());
        }
        this.paramIndex = params.toArray();
        this.vertexTypes = types.toArray(new String[0]);
        this.vertexIDs = new int[this.paramIndex.length];
        i = 0;
        while (i < this.paramIndex.length) {
            this.vertexIDs[i] = startID + i;
            ++i;
        }
    }

    public CallSite getCallSite() {
        return this.callsite;
    }

    public boolean isObjectParam(int param) {
        int i = 0;
        while (i < this.paramIndex.length) {
            if (this.paramIndex[i] == param) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getParamVertexId(int param) {
        int i = 0;
        while (i < this.paramIndex.length) {
            if (this.paramIndex[i] == param) {
                return this.vertexIDs[i];
            }
            ++i;
        }
        return VTAResolver.VERTEX_ERROR;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public boolean hasReturnValue() {
        if (this.paramIndex.length > 0) {
            return this.paramIndex[this.paramIndex.length - 1] == this.paramCount;
        }
        return false;
    }

    public int getReturnValueVertex() {
        if (this.hasReturnValue()) {
            return this.vertexIDs[this.paramIndex.length - 1];
        }
        return VTAResolver.VERTEX_ERROR;
    }

    public int getVertexCount() {
        return this.paramIndex.length;
    }

    public int getVertex(int vertexIndex) {
        return this.vertexIDs[vertexIndex];
    }

    public String getTypeName(int vertexIndex) {
        return this.vertexTypes[vertexIndex];
    }

    public String getReturnValueTypeName() {
        if (this.hasReturnValue()) {
            return this.vertexTypes[this.paramIndex.length - 1];
        }
        assert (false);
        return null;
    }
}

