/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import soba.core.MethodInfo;
import soba.core.method.LocalVariables;
import soba.core.signature.TypeConstants;
import soba.core.vta.VTAResolver;

public class MethodVertices {
    private LocalVariables locals;
    private int[] variableIndex;
    private int[] vertexIDs;
    private int returnVertexID;
    private int[] paramVertexIDs;
    private int vertexCount = 0;
    private ArrayList<String> typenames;

    public MethodVertices(MethodInfo m, LocalVariables table, int startID) {
        this.locals = table;
        this.variableIndex = new int[m.getParamCount()];
        this.typenames = new ArrayList();
        this.paramVertexIDs = new int[m.getParamCount()];
        int vID = startID;
        int var = 0;
        int i = 0;
        while (i < m.getParamCount()) {
            String type = m.getParamType(i);
            this.variableIndex[i] = var;
            var += TypeConstants.getWordCount(type);
            if (!TypeConstants.isPrimitiveOrVoid(type)) {
                this.paramVertexIDs[i] = vID++;
                this.typenames.add(type);
            }
            ++i;
        }
        TIntArrayList vertices = new TIntArrayList();
        int i2 = 0;
        while (i2 < this.locals.getVariableEntryCount()) {
            if (this.locals.isObjectVariable(i2)) {
                if (this.locals.isParameter(i2)) {
                    int paramIndex = this.getParamIndex(this.locals.getVariableIndex(i2));
                    vertices.add(this.paramVertexIDs[paramIndex]);
                } else {
                    vertices.add(vID);
                    ++vID;
                    String t = this.locals.getVariableType(i2);
                    if (t == null) {
                        t = this.locals.isArrayVariable(i2) ? "java/lang/Object[]" : "java/lang/Object";
                    }
                    this.typenames.add(t);
                }
            } else {
                vertices.add(VTAResolver.VERTEX_ERROR);
            }
            ++i2;
        }
        this.vertexIDs = vertices.toArray();
        if (!TypeConstants.isPrimitiveOrVoid(m.getReturnType())) {
            this.returnVertexID = vID++;
            this.typenames.add(m.getReturnType());
        }
        this.vertexCount = vID - startID;
    }

    public int getLocalVertex(int instruction) {
        int entryIndex = this.locals.findEntryForInstruction(instruction);
        if (entryIndex != -1) {
            return this.vertexIDs[entryIndex];
        }
        return VTAResolver.VERTEX_ERROR;
    }

    public int getReturnVertex() {
        return this.returnVertexID;
    }

    public int getFormalVertex(int paramIndex) {
        return this.paramVertexIDs[paramIndex];
    }

    public boolean hasFormalVertex(int paramIndex) {
        return this.paramVertexIDs[paramIndex] != VTAResolver.VERTEX_ERROR;
    }

    private int getParamIndex(int varIndex) {
        int i = 0;
        while (i < this.variableIndex.length) {
            if (this.variableIndex[i] == varIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public String getTypeName(int vertexIndex) {
        return this.typenames.get(vertexIndex);
    }
}

