/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.objectweb.asm.tree.InsnList;
import soba.core.ClassInfo;
import soba.core.JavaProgram;
import soba.core.JavaProgramTest;
import soba.core.MethodInfo;
import soba.core.vta.MethodVertices;
import soba.core.vta.VTAResolver;

public class MethodVerticesTest {
    private static JavaProgram program;
    private static MethodInfo m;
    private static MethodVertices v;
    private static final int startID = 1;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        program = JavaProgramTest.readExampleProgram();
        ClassInfo c = program.getClassInfo("soba/testdata/ObjectTransferCode");
        m = c.findMethod("newObject", "(I)[[I");
        v = new MethodVertices(m, m.getDataDependence().getLocalVariables(), 1);
    }

    @Test
    public void testGetLocalVertex() {
        int storeCount = 0;
        int loadCount = 0;
        InsnList instructions = MethodVerticesTest.m.getMethodNode().instructions;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 58) {
                if (storeCount <= 2) {
                    Assert.assertThat((Object)v.getLocalVertex(i), (Matcher)Matchers.is((Object)(1 + storeCount + 1)));
                } else if (storeCount == 3) {
                    Assert.assertThat((Object)v.getLocalVertex(i), (Matcher)Matchers.is((Object)7));
                } else {
                    Assert.assertThat((Object)v.getLocalVertex(i), (Matcher)Matchers.is((Object)(1 + storeCount)));
                }
                ++storeCount;
            } else if (instructions.get(i).getOpcode() == 25) {
                if (loadCount == 0) {
                    Assert.assertThat((Object)v.getLocalVertex(i), (Matcher)Matchers.is((Object)2));
                } else if (loadCount == 1 || loadCount == 3) {
                    Assert.assertThat((Object)v.getLocalVertex(i), (Matcher)Matchers.is((Object)1));
                } else if (loadCount == 2) {
                    Assert.assertThat((Object)v.getLocalVertex(i), (Matcher)Matchers.is((Object)3));
                } else {
                    Assert.assertThat((Object)v.getLocalVertex(i), (Matcher)Matchers.is((Object)(1 + loadCount - 1)));
                }
                ++loadCount;
            } else {
                Assert.assertThat((Object)v.getLocalVertex(i), (Matcher)Matchers.is((Object)VTAResolver.VERTEX_ERROR));
            }
            ++i;
        }
    }

    @Test
    public void testGetReturnVertex() {
        Assert.assertThat((Object)v.getReturnVertex(), (Matcher)Matchers.is((Object)8));
    }

    @Test
    public void testGetFormalVertex() {
        Assert.assertThat((Object)v.getFormalVertex(0), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testHasFormalVertex() {
        Assert.assertThat((Object)v.hasFormalVertex(0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)v.hasFormalVertex(1), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetVertexCount() {
        Assert.assertThat((Object)v.getVertexCount(), (Matcher)Matchers.is((Object)8));
    }

    @Test
    public void testGetTypeName() {
        Assert.assertThat((Object)v.getTypeName(0), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode"));
        Assert.assertThat((Object)v.getTypeName(1), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode"));
        Assert.assertThat((Object)v.getTypeName(2), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode"));
        Assert.assertThat((Object)v.getTypeName(3), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode"));
        Assert.assertThat((Object)v.getTypeName(4), (Matcher)Matchers.is((Object)"soba/testdata/ObjectTransferCode[]"));
        Assert.assertThat((Object)v.getTypeName(5), (Matcher)Matchers.is((Object)"int[][]"));
        Assert.assertThat((Object)v.getTypeName(6), (Matcher)Matchers.is((Object)"java/lang/Object"));
        Assert.assertThat((Object)v.getTypeName(7), (Matcher)Matchers.is((Object)"int[][]"));
    }
}

