/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import soba.core.signature.TypeResolver;
import soba.core.vta.VTAResolver;

public class NewVertices {
    private int[] instructionIndices;
    private int[] vertexIDs;
    private String[] types;

    public NewVertices(InsnList instructions, int startID) {
        TIntArrayList indices = new TIntArrayList();
        TIntArrayList vIDs = new TIntArrayList();
        ArrayList<String> typeNames = new ArrayList<String>();
        int vID = startID;
        int i = 0;
        while (i < instructions.size()) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() == 187) {
                indices.add(i);
                vIDs.add(vID);
                ++vID;
                typeNames.add(((TypeInsnNode)instruction).desc);
            } else if (instruction.getOpcode() == 189) {
                indices.add(i);
                vIDs.add(vID);
                ++vID;
                String desc = ((TypeInsnNode)instruction).desc;
                if (desc.startsWith("[")) {
                    typeNames.add(TypeResolver.getTypeName(desc));
                } else {
                    typeNames.add(String.valueOf(desc) + "[]");
                }
            } else if (instruction.getOpcode() == 197) {
                indices.add(i);
                vIDs.add(vID);
                ++vID;
                typeNames.add(TypeResolver.getTypeName(((MultiANewArrayInsnNode)instruction).desc));
            }
            ++i;
        }
        this.instructionIndices = indices.toArray();
        this.vertexIDs = vIDs.toArray();
        this.types = new String[typeNames.size()];
        i = 0;
        while (i < this.types.length) {
            this.types[i] = (String)typeNames.get(i);
            ++i;
        }
    }

    public int getNewInstructionVertex(int instructionIndex) {
        int i = 0;
        while (i < this.instructionIndices.length) {
            if (this.instructionIndices[i] == instructionIndex) {
                return this.vertexIDs[i];
            }
            ++i;
        }
        return VTAResolver.VERTEX_ERROR;
    }

    public int getVertex(int vertexIndex) {
        return this.vertexIDs[vertexIndex];
    }

    public String getTypeName(int vertexIndex) {
        return this.types[vertexIndex];
    }

    public int getVertexCount() {
        return this.vertexIDs.length;
    }
}

