/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import soba.core.ClassHierarchy;
import soba.core.ClassInfo;
import soba.core.FieldInfo;
import soba.core.IDynamicBindingResolver;
import soba.core.JavaProgram;
import soba.core.MethodInfo;
import soba.core.method.CallSite;
import soba.core.method.DataDependence;
import soba.core.signature.TypeConstants;
import soba.core.signature.TypeResolver;
import soba.core.vta.CallSiteVertices;
import soba.core.vta.IAnalysisTarget;
import soba.core.vta.ITopologicalVisitor;
import soba.core.vta.MethodVertices;
import soba.core.vta.NewVertices;
import soba.core.vta.TopologicalOrderSearch;
import soba.core.vta.TypeSet;
import soba.core.vta.TypeSetManager;
import soba.util.IntPairList;
import soba.util.graph.DirectedAcyclicGraph;
import soba.util.graph.DirectedGraph;

public class VTAResolver
implements IDynamicBindingResolver {
    public static int VERTEX_ERROR = 0;
    private static final String ARRAY_SUFFIX = "[]";
    private Map<FieldInfo, FieldVertex> fieldVertex;
    private Map<MethodInfo, CallSiteVertices[]> callsiteMap;
    private Map<MethodInfo, NewVertices> newVerticesMap;
    private Map<MethodInfo, MethodVertices> localVerticesMap;
    private TIntObjectHashMap<String> catchVariableVertices;
    private ArrayList<String> declaredTypeNames;
    private ClassHierarchy hierarchy;
    private IAnalysisTarget target;
    private IntPairList edges;
    private TypeSet[] reachingTypes;
    private TypeSetManager typeSetManager;

    public VTAResolver(JavaProgram program) {
        this(program, new IAnalysisTarget(){

            @Override
            public boolean isTargetMethod(MethodInfo m) {
                return true;
            }

            @Override
            public boolean isTargetField(FieldInfo f) {
                return true;
            }

            @Override
            public boolean isExcludedType(String className) {
                return false;
            }

            @Override
            public boolean assumeExternalCallers(MethodInfo m) {
                return false;
            }
        });
    }

    public VTAResolver(JavaProgram program, IAnalysisTarget selector) {
        DataDependence dataflow;
        MethodInfo m;
        int mIndex;
        this.target = selector;
        this.edges = new IntPairList(65536);
        this.hierarchy = program.getClassHierarchy();
        this.callsiteMap = new HashMap<MethodInfo, CallSiteVertices[]>();
        this.newVerticesMap = new HashMap<MethodInfo, NewVertices>();
        this.fieldVertex = new HashMap<FieldInfo, FieldVertex>();
        this.localVerticesMap = new HashMap<MethodInfo, MethodVertices>();
        this.catchVariableVertices = new TIntObjectHashMap();
        this.declaredTypeNames = new ArrayList(65536);
        ArrayList<CallSiteVertices> callsitesWithoutCallees = new ArrayList<CallSiteVertices>();
        this.fieldVertex = new HashMap<FieldInfo, FieldVertex>();
        int vID = VERTEX_ERROR + 1;
        this.declaredTypeNames.add("java/lang/Object");
        for (ClassInfo c : program.getClasses()) {
            mIndex = 0;
            while (mIndex < c.getMethodCount()) {
                m = c.getMethod(mIndex);
                if (m.hasMethodBody() && (selector == null || selector.isTargetMethod(m))) {
                    dataflow = m.getDataDependence();
                    MethodVertices localVertices = new MethodVertices(m, dataflow.getLocalVariables(), vID);
                    this.localVerticesMap.put(m, localVertices);
                    vID += localVertices.getVertexCount();
                    int i = 0;
                    while (i < localVertices.getVertexCount()) {
                        this.declaredTypeNames.add(localVertices.getTypeName(i));
                        ++i;
                    }
                }
                ++mIndex;
            }
            int fIndex = 0;
            while (fIndex < c.getFieldCount()) {
                FieldInfo f = c.getField(fIndex);
                if (!TypeConstants.isPrimitiveTypeName(f.getFieldTypeName())) {
                    FieldVertex fv = new FieldVertex(f, vID);
                    this.fieldVertex.put(f, fv);
                    ++vID;
                    this.declaredTypeNames.add(fv.getTypeName());
                }
                ++fIndex;
            }
        }
        for (ClassInfo c : program.getClasses()) {
            mIndex = 0;
            while (mIndex < c.getMethodCount()) {
                m = c.getMethod(mIndex);
                if (m.hasMethodBody() && (selector == null || selector.isTargetMethod(m))) {
                    dataflow = m.getDataDependence();
                    MethodNode mnode = m.getMethodNode();
                    NewVertices newVertices = new NewVertices(mnode.instructions, vID);
                    vID += newVertices.getVertexCount();
                    this.newVerticesMap.put(m, newVertices);
                    int i = 0;
                    while (i < newVertices.getVertexCount()) {
                        this.declaredTypeNames.add(newVertices.getTypeName(i));
                        assert (newVertices.getTypeName(i) != null);
                        ++i;
                    }
                    CallSiteVertices[] callsites = new CallSiteVertices[m.getInstructionCount()];
                    this.callsiteMap.put(m, callsites);
                    for (CallSite callsite : m.getCallSites()) {
                        CallSiteVertices actuals;
                        MethodInfo[] methods = this.hierarchy.resolveCall(callsite);
                        callsites[callsite.getInstructionIndex()] = actuals = new CallSiteVertices(callsite, vID);
                        vID += actuals.getVertexCount();
                        int i2 = 0;
                        while (i2 < actuals.getVertexCount()) {
                            this.declaredTypeNames.add(actuals.getTypeName(i2));
                            ++i2;
                        }
                        boolean methodNotIncluded = false;
                        if (methods.length > 0) {
                            MethodInfo[] methodInfoArray = methods;
                            int n = methods.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MethodInfo called = methodInfoArray[n2];
                                MethodVertices formals = this.localVerticesMap.get(called);
                                if (formals != null) {
                                    int i3 = 0;
                                    while (i3 < actuals.getParamCount()) {
                                        if (actuals.isObjectParam(i3)) {
                                            assert (actuals.getParamVertexId(i3) != VERTEX_ERROR);
                                            assert (formals.getFormalVertex(i3) != VERTEX_ERROR);
                                            this.addEdge(actuals.getParamVertexId(i3), formals.getFormalVertex(i3));
                                        }
                                        ++i3;
                                    }
                                    if (actuals.hasReturnValue()) {
                                        assert (formals.getReturnVertex() != VERTEX_ERROR);
                                        assert (actuals.getReturnValueVertex() != VERTEX_ERROR);
                                        this.addEdge(formals.getReturnVertex(), actuals.getReturnValueVertex());
                                    }
                                } else {
                                    methodNotIncluded = true;
                                }
                                ++n2;
                            }
                        }
                        if (!methodNotIncluded && methods.length != 0 || !actuals.hasReturnValue()) continue;
                        callsitesWithoutCallees.add(actuals);
                    }
                    int i4 = 0;
                    while (i4 < m.getInstructionCount()) {
                        AbstractInsnNode instruction = mnode.instructions.get(i4);
                        this.analyzeInstruction(i4, instruction, m, dataflow);
                        ++i4;
                    }
                }
                ++mIndex;
            }
        }
        DirectedGraph graph = new DirectedGraph(vID, this.edges);
        DirectedAcyclicGraph typePropagationDAG = new DirectedAcyclicGraph(graph);
        this.typeSetManager = new TypeSetManager();
        this.assignTypes(typePropagationDAG, callsitesWithoutCallees, selector);
        this.propagateTypes(typePropagationDAG);
    }

    @Override
    public MethodInfo[] resolveCall(CallSite cs) {
        int instruction = cs.getInstructionIndex();
        CallSiteVertices[] callsites = this.callsiteMap.get(cs.getOwnerMethod());
        if (callsites != null) {
            CallSiteVertices params = callsites[instruction];
            if (params != null) {
                HashSet<MethodInfo> called = new HashSet<MethodInfo>();
                int v = params.getParamVertexId(0);
                TypeSet types = this.reachingTypes[v];
                String methodName = params.getCallSite().getMethodName();
                String methodDesc = params.getCallSite().getDescriptor();
                if (types != null) {
                    ArrayList<String> declaredType = new ArrayList<String>();
                    declaredType.add(this.declaredTypeNames.get(v));
                    Collection<String> declaredSubtypes = this.hierarchy.getAllSubtypes(declaredType);
                    int i = 0;
                    while (i < types.getTypeCount()) {
                        MethodInfo m;
                        String className = types.getType(i);
                        if (declaredSubtypes.contains(className) && (m = this.hierarchy.resolveSpecialCall(className, methodName, methodDesc)) != null && !this.target.isExcludedType(m.getClassName())) {
                            called.add(m);
                        }
                        ++i;
                    }
                    ArrayList<String> approxTypes = new ArrayList<String>();
                    int i2 = 0;
                    while (i2 < types.getApproximatedTypeCount()) {
                        approxTypes.add(types.getApproximatedType(i2));
                        ++i2;
                    }
                    Collection<String> subtypes = this.hierarchy.getAllSubtypes(approxTypes);
                    for (String className : subtypes) {
                        MethodInfo m;
                        if (!declaredSubtypes.contains(className) || (m = this.hierarchy.resolveSpecialCall(className, methodName, methodDesc)) == null || this.target.isExcludedType(m.getClassName())) continue;
                        called.add(m);
                    }
                    MethodInfo[] methods = called.toArray(new MethodInfo[0]);
                    Arrays.sort(methods, new Comparator<MethodInfo>(){

                        @Override
                        public int compare(MethodInfo o1, MethodInfo o2) {
                            int idx = o1.getClassName().compareTo(o2.getClassName());
                            if (idx != 0) {
                                return idx;
                            }
                            idx = o1.getMethodName().compareTo(o2.getMethodName());
                            if (idx != 0) {
                                return idx;
                            }
                            idx = o1.getDescriptor().compareTo(o2.getDescriptor());
                            if (idx != 0) {
                                return idx;
                            }
                            return o1.hashCode() - o2.hashCode();
                        }
                    });
                    return methods;
                }
                return new MethodInfo[0];
            }
            return new MethodInfo[0];
        }
        return new MethodInfo[0];
    }

    private void assignTypes(final DirectedAcyclicGraph typePropagationDAG, List<CallSiteVertices> callsitesWithoutCallees, IAnalysisTarget selector) {
        int v;
        this.reachingTypes = new TypeSet[typePropagationDAG.getVertexCount()];
        for (NewVertices newVertices : this.newVerticesMap.values()) {
            int i = 0;
            while (i < newVertices.getVertexCount()) {
                String typeName = this.extractBaseType(newVertices.getTypeName(i));
                v = newVertices.getVertex(i);
                this.assignSpecificType(typePropagationDAG, v, typeName);
                ++i;
            }
        }
        for (CallSiteVertices callSiteVertices : callsitesWithoutCallees) {
            assert (callSiteVertices.hasReturnValue());
            int v2 = callSiteVertices.getReturnValueVertex();
            this.assignApproximatedType(typePropagationDAG, v2, this.extractBaseType(callSiteVertices.getReturnValueTypeName()));
        }
        for (MethodInfo methodInfo : this.localVerticesMap.keySet()) {
            if (selector == null || !selector.assumeExternalCallers(methodInfo)) continue;
            MethodVertices methodVertices = this.localVerticesMap.get(methodInfo);
            int i = 0;
            while (i < methodInfo.getParamCount()) {
                if (methodVertices.hasFormalVertex(i)) {
                    v = methodVertices.getFormalVertex(i);
                    this.assignApproximatedType(typePropagationDAG, v, this.extractBaseType(methodInfo.getParamType(i)));
                }
                ++i;
            }
        }
        this.catchVariableVertices.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<String>(){

            public boolean execute(int v, String typeName) {
                VTAResolver.this.assignApproximatedType(typePropagationDAG, v, typeName);
                return true;
            }
        });
        if (selector != null) {
            for (FieldVertex fieldVertex : this.fieldVertex.values()) {
                int vertexId = fieldVertex.getId();
                FieldInfo f = fieldVertex.getFieldInfo();
                if (selector.isTargetField(f)) continue;
                this.assignApproximatedType(typePropagationDAG, vertexId, this.extractBaseType(fieldVertex.getTypeName()));
            }
        }
    }

    private void assignSpecificType(DirectedAcyclicGraph typePropagationDAG, int v, String typeName) {
        this.reachingTypes[v] = this.reachingTypes[v = typePropagationDAG.getRepresentativeNode(v)] == null ? new TypeSet(this.typeSetManager, typeName) : this.reachingTypes[v].addType(typeName);
    }

    private void assignApproximatedType(DirectedAcyclicGraph typePropagationDAG, int v, String typeName) {
        this.reachingTypes[v] = this.reachingTypes[v = typePropagationDAG.getRepresentativeNode(v)] == null ? TypeSet.createApproximation(this.typeSetManager, typeName) : this.reachingTypes[v].addApproximatedType(typeName);
    }

    private void propagateTypes(final DirectedAcyclicGraph typePropagationDAG) {
        final DirectedAcyclicGraph reverse = typePropagationDAG.getReverseGraph();
        TopologicalOrderSearch.searchFromRoot(typePropagationDAG, new ITopologicalVisitor(){

            @Override
            public boolean onVisit(int vertexId) {
                if (vertexId == VERTEX_ERROR) {
                    ((VTAResolver)VTAResolver.this).reachingTypes[vertexId] = new TypeSet(VTAResolver.this.typeSetManager);
                    return true;
                }
                int[] incoming = reverse.getEdges(vertexId);
                if (incoming.length == 1) {
                    if (VTAResolver.this.reachingTypes[vertexId] == null) {
                        ((VTAResolver)VTAResolver.this).reachingTypes[vertexId] = VTAResolver.this.reachingTypes[incoming[0]];
                    } else {
                        ArrayList<TypeSet> types = new ArrayList<TypeSet>();
                        types.add(VTAResolver.this.reachingTypes[vertexId]);
                        types.add(VTAResolver.this.reachingTypes[incoming[0]]);
                        ((VTAResolver)VTAResolver.this).reachingTypes[vertexId] = new TypeSet(VTAResolver.this.typeSetManager, types);
                    }
                } else if (incoming.length > 1) {
                    ArrayList<TypeSet> types = new ArrayList<TypeSet>();
                    if (VTAResolver.this.reachingTypes[vertexId] != null) {
                        types.add(VTAResolver.this.reachingTypes[vertexId]);
                    }
                    int i = 0;
                    while (i < incoming.length) {
                        if (!$assertionsDisabled && VTAResolver.this.reachingTypes[incoming[i]] == null) {
                            throw new AssertionError();
                        }
                        types.add(VTAResolver.this.reachingTypes[incoming[i]]);
                        ++i;
                    }
                    ((VTAResolver)VTAResolver.this).reachingTypes[vertexId] = new TypeSet(VTAResolver.this.typeSetManager, types);
                } else {
                    if (!$assertionsDisabled && incoming.length != 0) {
                        throw new AssertionError((Object)"Unreachable vertices");
                    }
                    if (VTAResolver.this.reachingTypes[vertexId] == null) {
                        ((VTAResolver)VTAResolver.this).reachingTypes[vertexId] = new TypeSet(VTAResolver.this.typeSetManager);
                    }
                }
                return true;
            }

            @Override
            public void onFinished() {
                int i = 0;
                while (i < VTAResolver.this.reachingTypes.length) {
                    int v = typePropagationDAG.getRepresentativeNode(i);
                    if (v != i) {
                        ((VTAResolver)VTAResolver.this).reachingTypes[i] = VTAResolver.this.reachingTypes[v];
                    }
                    ++i;
                }
            }
        });
    }

    private void analyzeInstruction(int index, AbstractInsnNode instruction, MethodInfo m, DataDependence dataflow) {
        switch (instruction.getOpcode()) {
            case 176: {
                int[] sources;
                int targetVertexId = this.localVerticesMap.get(m).getReturnVertex();
                int[][] operandSources = dataflow.getDataDefinition(index);
                assert (operandSources.length == 1) : "ARETURN takes a single parameter.";
                int[] nArray = sources = operandSources[0];
                int n = sources.length;
                int n2 = 0;
                while (n2 < n) {
                    int sourceInstructionIndex = nArray[n2];
                    int[] nArray2 = this.getSourceVertices(sourceInstructionIndex, m, dataflow);
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int sourceId = nArray2[n4];
                        this.addEdge(sourceId, targetVertexId);
                        ++n4;
                    }
                    ++n2;
                }
                break;
            }
            case 179: 
            case 181: {
                int[] sources;
                FieldVertex v = this.getFieldVertexId((FieldInsnNode)instruction);
                if (v == null) {
                    return;
                }
                int targetVertexId = v.getId();
                int[][] operandSources = dataflow.getDataDefinition(index);
                if (instruction.getOpcode() == 181) {
                    assert (operandSources.length == 2) : "PUTFIELD takes two parameters (object and value)";
                    sources = operandSources[1];
                } else {
                    assert (operandSources.length == 1) : "PUTFIELD takes a parameter (value)";
                    sources = operandSources[0];
                }
                int[] sourceId = sources;
                int n = sources.length;
                int n5 = 0;
                while (n5 < n) {
                    int sourceInstructionIndex = sourceId[n5];
                    int[] nArray = this.getSourceVertices(sourceInstructionIndex, m, dataflow);
                    int n6 = nArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        int sourceId2 = nArray[n7];
                        this.addEdge(sourceId2, targetVertexId);
                        ++n7;
                    }
                    ++n5;
                }
                break;
            }
            case 58: {
                int[][] operandSources = dataflow.getDataDefinition(index);
                int[] sources = operandSources[0];
                assert (operandSources.length == 1) : "ASTORE takes a single parameter (value)";
                if (sources.length == 1 && sources[0] == -1) {
                    List blocks = m.getMethodNode().tryCatchBlocks;
                    int i = 0;
                    while (i < blocks.size()) {
                        TryCatchBlockNode node = (TryCatchBlockNode)blocks.get(i);
                        LabelNode handler = node.handler;
                        while (handler != null) {
                            if (handler == instruction) {
                                int vertexId = this.getLocalVariableVertex(m, index);
                                String type = node.type;
                                if (type == null) {
                                    type = "java/lang/Object";
                                }
                                this.catchVariableVertices.put(vertexId, (Object)type);
                                return;
                            }
                            if (handler.getType() != 8 && handler.getType() != 14 && handler.getType() != 15) break;
                            handler = handler.getNext();
                        }
                        ++i;
                    }
                    assert (false) : "A separated ASTORE outside of try-catch blocks.";
                    break;
                }
                int targetVertexId = this.getLocalVariableVertex(m, index);
                if (targetVertexId != VERTEX_ERROR) {
                    int[] nArray = sources;
                    int n = sources.length;
                    int node = 0;
                    while (node < n) {
                        int sourceInstructionIndex = nArray[node];
                        int[] nArray3 = this.getSourceVertices(sourceInstructionIndex, m, dataflow);
                        int n8 = nArray3.length;
                        int sourceId2 = 0;
                        while (sourceId2 < n8) {
                            int sourceId = nArray3[sourceId2];
                            this.addEdge(sourceId, targetVertexId);
                            ++sourceId2;
                        }
                        ++node;
                    }
                    break;
                }
                assert (false) : "ASTORE must have its corresponding ALOAD.";
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                CallSiteVertices actuals = this.callsiteMap.get(m)[index];
                if (actuals == null) break;
                int[][] operandSources = dataflow.getDataDefinition(index);
                assert (operandSources.length == actuals.getParamCount()) : "The number of operands must be the same as the number of actual vertices.";
                int i = 0;
                while (i < actuals.getParamCount()) {
                    if (actuals.isObjectParam(i)) {
                        int actualId = actuals.getParamVertexId(i);
                        int[] sourceId = operandSources[i];
                        int n = sourceId.length;
                        int n9 = 0;
                        while (n9 < n) {
                            int sourceInstruction = sourceId[n9];
                            int[] nArray = this.getSourceVertices(sourceInstruction, m, dataflow);
                            int n10 = nArray.length;
                            int n11 = 0;
                            while (n11 < n10) {
                                int sourceVertexId = nArray[n11];
                                this.addEdge(sourceVertexId, actualId);
                                ++n11;
                            }
                            ++n9;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 83: {
                int[][] operandSources = dataflow.getDataDefinition(index);
                int[] arraySources = operandSources[0];
                int[] valueSources = operandSources[2];
                assert (operandSources.length == 3) : "AASTORE takes three parameters: object, index and value.";
                int[] nArray = valueSources;
                int n = valueSources.length;
                int n12 = 0;
                while (n12 < n) {
                    int valueSourceInstructionIndex = nArray[n12];
                    int[] nArray4 = this.getSourceVertices(valueSourceInstructionIndex, m, dataflow);
                    int n13 = nArray4.length;
                    int n14 = 0;
                    while (n14 < n13) {
                        int sourceId = nArray4[n14];
                        int[] nArray5 = arraySources;
                        int n15 = arraySources.length;
                        int n16 = 0;
                        while (n16 < n15) {
                            int arraySourceInstructionIndex = nArray5[n16];
                            int[] nArray6 = this.getSourceVertices(arraySourceInstructionIndex, m, dataflow);
                            int n17 = nArray6.length;
                            int n18 = 0;
                            while (n18 < n17) {
                                int arrayId = nArray6[n18];
                                this.addEdge(sourceId, arrayId);
                                ++n18;
                            }
                            ++n16;
                        }
                        ++n14;
                    }
                    ++n12;
                }
                break;
            }
        }
    }

    private void addEdge(int sourceVertex, int destinationVertex) {
        this.edges.add(sourceVertex, destinationVertex);
        String sourceType = this.declaredTypeNames.get(sourceVertex);
        String destinationType = this.declaredTypeNames.get(destinationVertex);
        if (sourceType.endsWith(ARRAY_SUFFIX) || destinationType.endsWith(ARRAY_SUFFIX) || sourceType.equals("java/lang/Object") && destinationType.equals("java/lang/Object")) {
            this.edges.add(destinationVertex, sourceVertex);
        }
    }

    private int getLocalVariableVertex(MethodInfo m, int instructionIndex) {
        MethodVertices l = this.localVerticesMap.get(m);
        if (l != null) {
            return l.getLocalVertex(instructionIndex);
        }
        assert (false) : "MethodVertices is not registered.";
        return VERTEX_ERROR;
    }

    private int[] getSourceVertices(int instructionIndex, MethodInfo m, DataDependence dataflow) {
        assert (instructionIndex >= 0) : "Instruction must be >=0 : " + Integer.toString(instructionIndex);
        InsnList instructions = m.getMethodNode().instructions;
        AbstractInsnNode node = instructions.get(instructionIndex);
        switch (node.getOpcode()) {
            case 192: {
                int[][] operands = dataflow.getDataDefinition(instructionIndex);
                assert (operands.length == 1) : "CHECKCAST takes a single parameter.";
                TIntArrayList defs = new TIntArrayList();
                int[] nArray = operands[0];
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int sourceInstruction = nArray[n2];
                    defs.add(this.getSourceVertices(sourceInstruction, m, dataflow));
                    ++n2;
                }
                return defs.toArray();
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                CallSiteVertices[] sites = this.callsiteMap.get(m);
                if (sites[instructionIndex] != null) {
                    return new int[]{sites[instructionIndex].getReturnValueVertex()};
                }
                return new int[]{VERTEX_ERROR};
            }
            case 178: 
            case 180: {
                FieldInsnNode f = (FieldInsnNode)node;
                FieldVertex v = this.getFieldVertexId(f);
                if (v != null) {
                    return new int[]{v.getId()};
                }
                return new int[0];
            }
            case 50: {
                int[][] operands = dataflow.getDataDefinition(instructionIndex);
                assert (operands.length == 2) : "AALOAD takes two parameters.";
                TIntArrayList defs = new TIntArrayList();
                int[] nArray = operands[0];
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int sourceInstruction = nArray[n3];
                    defs.add(this.getSourceVertices(sourceInstruction, m, dataflow));
                    ++n3;
                }
                return defs.toArray();
            }
            case 25: {
                return new int[]{this.getLocalVariableVertex(m, instructionIndex)};
            }
            case 187: 
            case 189: 
            case 197: {
                return new int[]{this.newVerticesMap.get(m).getNewInstructionVertex(instructionIndex)};
            }
        }
        return new int[]{VERTEX_ERROR};
    }

    private FieldVertex getFieldVertexId(FieldInsnNode node) {
        FieldInfo f;
        String owner;
        String className = node.owner;
        String fieldName = node.name;
        String desc = node.desc;
        if (node.getOpcode() == 179 || node.getOpcode() == 178) {
            owner = this.hierarchy.resolveStaticFieldOwner(className, fieldName, desc);
        } else {
            assert (node.getOpcode() == 181 || node.getOpcode() == 180);
            owner = this.hierarchy.resolveInstanceFieldOwner(className, fieldName, desc);
        }
        ClassInfo c = this.hierarchy.getClassInfo(owner);
        if (c != null && (f = c.findField(fieldName, desc)) != null) {
            FieldVertex fv = this.fieldVertex.get(f);
            if (fv != null) {
                return fv;
            }
            assert (TypeConstants.isPrimitiveTypeName(f.getFieldTypeName()));
            return null;
        }
        return null;
    }

    public TypeSet getReceiverTypeAtCallsite(MethodInfo m, int instruction) {
        CallSiteVertices[] callsites = this.callsiteMap.get(m);
        if (callsites != null) {
            CallSiteVertices params = callsites[instruction];
            if (params != null) {
                if (!params.getCallSite().isStaticMethod()) {
                    int v = params.getParamVertexId(0);
                    return this.reachingTypes[v];
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public TypeSet getMethodParamType(MethodInfo m, int paramIndex) {
        MethodVertices vertices = this.localVerticesMap.get(m);
        if (vertices.hasFormalVertex(paramIndex)) {
            return this.reachingTypes[vertices.getFormalVertex(paramIndex)];
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private String extractBaseType(String typename) {
        if (VTAResolver.$assertionsDisabled || typename != null) ** GOTO lbl4
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            typename = typename.substring(0, typename.length() - 2);
lbl4:
            // 2 sources

            ** while (typename.endsWith((String)"[]"))
        }
lbl5:
        // 1 sources

        if (!VTAResolver.$assertionsDisabled && typename == null) {
            throw new AssertionError();
        }
        return typename;
    }

    private static class FieldVertex {
        private int vertexID;
        private FieldInfo fieldInfo;

        public FieldVertex(FieldInfo f, int vID) {
            this.vertexID = vID;
            this.fieldInfo = f;
        }

        public int getId() {
            return this.vertexID;
        }

        public String getTypeName() {
            return TypeResolver.getTypeName(this.fieldInfo.getDescriptor());
        }

        public FieldInfo getFieldInfo() {
            return this.fieldInfo;
        }
    }
}

