/*
 * Decompiled with CFR 0.152.
 */
package soba.core.vta;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import soba.core.ClassInfo;
import soba.core.ExampleProgram;
import soba.core.FieldInfo;
import soba.core.JavaProgram;
import soba.core.JavaProgramTest;
import soba.core.MethodInfo;
import soba.core.vta.IAnalysisTarget;
import soba.core.vta.TypeSet;
import soba.core.vta.VTAResolver;

public class VTAResolverTest
implements ExampleProgram {
    private static JavaProgram program;
    private static VTAResolver resolver;

    @BeforeClass
    public static void setupResolver() {
        program = JavaProgramTest.readExampleProgram();
        resolver = new VTAResolver(program, new IAnalysisTarget(){

            @Override
            public boolean assumeExternalCallers(MethodInfo m) {
                return false;
            }

            @Override
            public boolean isExcludedType(String className) {
                return false;
            }

            @Override
            public boolean isTargetMethod(MethodInfo m) {
                return m.getClassName().startsWith("soba/testdata");
            }

            @Override
            public boolean isTargetField(FieldInfo f) {
                return true;
            }
        });
    }

    private void checkClasses(MethodInfo[] resolved, String ... classNames) {
        ArrayList<String> classes = new ArrayList<String>();
        MethodInfo[] methodInfoArray = resolved;
        int n = resolved.length;
        int n2 = 0;
        while (n2 < n) {
            MethodInfo m = methodInfoArray[n2];
            classes.add(m.getClassName());
            ++n2;
        }
        Assert.assertThat(classes, (Matcher)Matchers.containsInAnyOrder((Object[])classNames));
    }

    @Test
    public void testResolveCall01() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance2/E");
        MethodInfo m = c.findMethod("testDynamicBinding1", "()V");
        InsnList instructions = m.getMethodNode().instructions;
        int counter = 0;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 182) {
                if (counter == 0 || counter == 1) {
                    MethodInfo[] methods = resolver.resolveCall(m.getCallSite(i));
                    this.checkClasses(methods, "soba/testdata/inheritance1/D", "soba/testdata/inheritance1/G");
                }
                ++counter;
            }
            ++i;
        }
        Assert.assertThat((Object)counter, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testResolveCall02() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance2/E");
        MethodInfo m = c.findMethod("testDynamicBinding2", "()V");
        InsnList instructions = m.getMethodNode().instructions;
        int counter = 0;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 182) {
                MethodInfo[] methods;
                if (counter == 0) {
                    methods = resolver.resolveCall(m.getCallSite(i));
                    this.checkClasses(methods, "soba/testdata/inheritance1/D");
                } else if (counter == 1) {
                    methods = resolver.resolveCall(m.getCallSite(i));
                    this.checkClasses(methods, "soba/testdata/inheritance1/G");
                }
                ++counter;
            }
            ++i;
        }
        Assert.assertThat((Object)counter, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testResolvedCall03() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance2/E");
        MethodInfo m = c.findMethod("testDynamicBinding3", "()V");
        InsnList instructions = m.getMethodNode().instructions;
        int counter = 0;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 182) {
                MethodInfo[] methods;
                if (counter == 0) {
                    methods = resolver.resolveCall(m.getCallSite(i));
                    this.checkClasses(methods, "soba/testdata/inheritance1/C");
                } else if (counter == 1) {
                    methods = resolver.resolveCall(m.getCallSite(i));
                    this.checkClasses(methods, "soba/testdata/inheritance1/C");
                }
                ++counter;
            }
            ++i;
        }
    }

    @Test
    public void testResolvedCall04() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance2/E");
        MethodInfo m = c.findMethod("testDynamicBinding6", "(Lsoba/testdata/inheritance2/L;)V");
        InsnList instructions = m.getMethodNode().instructions;
        int counter = 0;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 182) {
                MethodInfo[] methods;
                if (counter == 0) {
                    methods = resolver.resolveCall(m.getCallSite(i));
                    Assert.assertThat((Object)methods, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
                } else if (counter == 1) {
                    methods = resolver.resolveCall(m.getCallSite(i));
                    this.checkClasses(methods, "soba/testdata/inheritance1/C", "soba/testdata/inheritance1/D", "soba/testdata/inheritance1/G");
                }
                ++counter;
            }
            ++i;
        }
    }

    @Test
    public void testResolveCall05() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance2/E");
        MethodInfo m = c.findMethod("testDynamicBinding7", "(Z)V");
        InsnList instructions = m.getMethodNode().instructions;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 182) {
                MethodInfo[] methods = resolver.resolveCall(m.getCallSite(i));
                this.checkClasses(methods, "java/util/ArrayList", "java/util/LinkedList");
            }
            ++i;
        }
    }

    private void checkLoopBinding(MethodInfo m) {
        InsnList instructions = m.getMethodNode().instructions;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 182) {
                MethodInsnNode call = (MethodInsnNode)instructions.get(i);
                if (call.name.equals("x")) {
                    MethodInfo[] methods = resolver.resolveCall(m.getCallSite(i));
                    this.checkClasses(methods, "soba/testdata/inheritance1/D", "soba/testdata/inheritance1/G");
                }
            }
            ++i;
        }
    }

    private void checkParamBinding(MethodInfo m) {
        TypeSet typeset = resolver.getMethodParamType(m, 1);
        Assert.assertThat((Object)typeset.getTypeCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testLoopBinding() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance2/E");
        this.checkLoopBinding(c.findMethod("testDynamicBinding4", "(Lsoba/testdata/inheritance1/C;)V"));
        this.checkLoopBinding(c.findMethod("testDynamicBinding5", "(Lsoba/testdata/inheritance1/C;)V"));
    }

    @Test
    public void testMethodParamType() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance2/E");
        this.checkParamBinding(c.findMethod("testDynamicBinding4", "(Lsoba/testdata/inheritance1/C;)V"));
        this.checkParamBinding(c.findMethod("testDynamicBinding5", "(Lsoba/testdata/inheritance1/C;)V"));
    }

    @Test
    public void testgetReceiverTypeAtCallsite() {
        ClassInfo c = program.getClassInfo("soba/testdata/inheritance1/C");
        MethodInfo m = c.findMethod("main", "([Ljava/lang/String;)V");
        InsnList instructions = m.getMethodNode().instructions;
        int count = 0;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 182) {
                TypeSet typeSet;
                if (count == 0) {
                    typeSet = resolver.getReceiverTypeAtCallsite(m, i);
                    Assert.assertThat((Object)typeSet.getTypeCount(), (Matcher)Matchers.is((Object)0));
                } else {
                    typeSet = resolver.getReceiverTypeAtCallsite(m, i);
                    Assert.assertThat((Object)typeSet.getTypeCount(), (Matcher)Matchers.is((Object)1));
                }
                ++count;
            }
            ++i;
        }
    }

    @Test
    public void testReflection() {
        ClassInfo c = program.getClassInfo("soba/testdata/ReflectionCode");
        MethodInfo m = c.findMethod("newInstanceUser", "()V");
        InsnList instructions = m.getMethodNode().instructions;
        int counter = 0;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 182) {
                MethodInsnNode call = (MethodInsnNode)instructions.get(i);
                if (call.name.equals("toString")) {
                    MethodInfo[] methods = resolver.resolveCall(m.getCallSite(i));
                    if (++counter == 1) {
                        this.checkClasses(methods, "soba/testdata/inheritance1/C", "soba/testdata/inheritance1/D");
                    } else {
                        this.checkClasses(methods, "soba/testdata/inheritance1/D");
                    }
                }
            }
            ++i;
        }
        Assert.assertThat((Object)counter, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testReflection2() {
        ClassInfo c = program.getClassInfo("soba/testdata/ReflectionCode");
        MethodInfo m = c.findMethod("newInstanceUser2", "()V");
        InsnList instructions = m.getMethodNode().instructions;
        int counter = 0;
        int i = 0;
        while (i < instructions.size()) {
            if (instructions.get(i).getOpcode() == 182) {
                MethodInsnNode call = (MethodInsnNode)instructions.get(i);
                if (call.name.equals("toString")) {
                    MethodInfo[] methods = resolver.resolveCall(m.getCallSite(i));
                    Assert.assertThat((Object)methods.length, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1))));
                    ++counter;
                }
            }
            ++i;
        }
        Assert.assertThat((Object)counter, (Matcher)Matchers.is((Object)1));
    }
}

