/*
 * Decompiled with CFR 0.152.
 */
package soba.util;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import soba.util.IntPairList;
import soba.util.IntPairProc;

public class IntPairListTest {
    @Test
    public void testAdd() throws Exception {
        IntPairList list = new IntPairList(2);
        list.add(1, 2);
        list.add(3, 4);
        list.add(5, 6);
        Assert.assertThat((Object)list.getFirstValue(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)list.getSecondValue(0), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)list.getFirstValue(1), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)list.getSecondValue(1), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)list.getFirstValue(2), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)list.getSecondValue(2), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testSortByFirstValues() throws Exception {
        IntPairList list = new IntPairList();
        list.add(1, 1);
        list.add(2, 0);
        list.add(3, 0);
        list.add(4, 4);
        list.add(5, 5);
        list.add(6, 3);
        list.add(7, 2);
        list.add(8, 4);
        list.add(9, 1);
        list.add(0, 5);
        list.sort();
        Assert.assertThat((Object)list.getFirstValue(2), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)list.getSecondValue(2), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)list.getFirstValue(4), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)list.getSecondValue(4), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)list.getFirstValue(9), (Matcher)Matchers.is((Object)9));
        Assert.assertThat((Object)list.getSecondValue(9), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testSetValues() throws Exception {
        IntPairList list = new IntPairList(2);
        list.add(1, 2);
        list.add(3, 4);
        list.add(5, 6);
        list.setFirstValue(1, 10);
        Assert.assertThat((Object)list.getFirstValue(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)list.getFirstValue(1), (Matcher)Matchers.is((Object)10));
        Assert.assertThat((Object)list.getFirstValue(2), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)list.getSecondValue(0), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)list.getSecondValue(1), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)list.getSecondValue(2), (Matcher)Matchers.is((Object)6));
        list.setSecondValue(2, 27);
        Assert.assertThat((Object)list.getFirstValue(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)list.getFirstValue(1), (Matcher)Matchers.is((Object)10));
        Assert.assertThat((Object)list.getFirstValue(2), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)list.getSecondValue(0), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)list.getSecondValue(1), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)list.getSecondValue(2), (Matcher)Matchers.is((Object)27));
    }

    @Test
    public void testAddAll() {
        IntPairList list = new IntPairList(2);
        list.add(1, 2);
        list.add(3, 4);
        IntPairList another = new IntPairList(2);
        another.add(5, 6);
        another.add(7, 8);
        list.addAll(another);
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)list.getFirstValue(0), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)list.getSecondValue(0), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)list.getFirstValue(1), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)list.getSecondValue(1), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)list.getFirstValue(2), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)list.getSecondValue(2), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)list.getFirstValue(3), (Matcher)Matchers.is((Object)7));
        Assert.assertThat((Object)list.getSecondValue(3), (Matcher)Matchers.is((Object)8));
        Assert.assertThat((Object)another.size(), (Matcher)Matchers.is((Object)2));
        another.addAll(another);
        Assert.assertThat((Object)another.size(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)another.getFirstValue(0), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)another.getSecondValue(0), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)another.getFirstValue(1), (Matcher)Matchers.is((Object)7));
        Assert.assertThat((Object)another.getSecondValue(1), (Matcher)Matchers.is((Object)8));
        Assert.assertThat((Object)another.getFirstValue(2), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)another.getSecondValue(2), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)another.getFirstValue(3), (Matcher)Matchers.is((Object)7));
        Assert.assertThat((Object)another.getSecondValue(3), (Matcher)Matchers.is((Object)8));
    }

    @Test
    public void testFreeze() {
        IntPairList list = new IntPairList(2);
        list.add(1, 2);
        list.freeze();
        try {
            list.add(3, 4);
            Assert.fail();
        }
        catch (IntPairList.FrozenListException frozenListException) {
            // empty catch block
        }
        try {
            list.setFirstValue(0, 1);
            Assert.fail();
        }
        catch (IntPairList.FrozenListException frozenListException) {
            // empty catch block
        }
        try {
            list.addAll(list);
            Assert.fail();
        }
        catch (IntPairList.FrozenListException frozenListException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayIndexOutOfBounds() {
        IntPairList list = new IntPairList(2);
        list.add(1, 2);
        try {
            list.getFirstValue(-1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.getFirstValue(1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.getSecondValue(-1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.getSecondValue(1);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testForEach() {
        IntPairList list = new IntPairList(2);
        list.add(1, 2);
        list.add(3, 4);
        list.add(5, 6);
        list.foreach(new IntPairProc(){
            int times = 0;

            @Override
            public boolean execute(int elem1, int elem2) {
                if (this.times == 0) {
                    Assert.assertThat((Object)elem1, (Matcher)Matchers.is((Object)1));
                    Assert.assertThat((Object)elem2, (Matcher)Matchers.is((Object)2));
                } else if (this.times == 1) {
                    Assert.assertThat((Object)elem1, (Matcher)Matchers.is((Object)3));
                    Assert.assertThat((Object)elem2, (Matcher)Matchers.is((Object)4));
                } else {
                    Assert.fail();
                }
                ++this.times;
                return this.times == 1;
            }
        });
    }
}

