/*
 * Decompiled with CFR 0.152.
 */
package soba.util;

import java.util.EmptyStackException;

public class IntStack {
    private int count = 0;
    private int[] values;

    public IntStack() {
        this(1024);
    }

    public IntStack(int capacity) {
        this.values = new int[capacity];
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void push(int value) {
        if (this.count >= this.values.length) {
            this.growUp();
        }
        this.values[this.count] = value;
        ++this.count;
    }

    public int pop() {
        if (this.count == 0) {
            throw new EmptyStackException();
        }
        --this.count;
        return this.values[this.count];
    }

    public int peek() {
        if (this.count == 0) {
            throw new EmptyStackException();
        }
        return this.values[this.count - 1];
    }

    public boolean contains(int value) {
        int i = 0;
        while (i < this.count) {
            if (this.values[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void growUp() {
        int[] newValues = new int[this.values.length * 2];
        int i = 0;
        while (i < this.count) {
            newValues[i] = this.values[i];
            ++i;
        }
        this.values = newValues;
    }

    public int size() {
        return this.count;
    }
}

