/*
 * Decompiled with CFR 0.152.
 */
package soba.util.files;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import soba.util.files.Directory;
import soba.util.files.IClassList;
import soba.util.files.SingleFile;
import soba.util.files.ZipFile;

public class ClasspathUtil {
    public static IClassList[] getClassList(String[] files) {
        return ClasspathUtil.getClassList(Arrays.asList(files), null);
    }

    public static IClassList[] getClassList(String[] files, String label) {
        return ClasspathUtil.getClassList(Arrays.asList(files), label);
    }

    public static IClassList[] getClassList(List<String> files) {
        return ClasspathUtil.getClassList(files, null);
    }

    public static IClassList[] getClassList(String[] appFiles, String[] libFiles) {
        IClassList[] apps = ClasspathUtil.getClassList(appFiles);
        IClassList[] libs = ClasspathUtil.getClassList(libFiles, "$library$");
        return ClasspathUtil.merge(apps, libs);
    }

    public static IClassList[] getClassList(List<String> files, String label) {
        ArrayList<IClassList> result = new ArrayList<IClassList>();
        for (String filepath : files) {
            File f = new File(filepath);
            if (f.isDirectory()) {
                Directory dir = new Directory(f);
                dir.enableRecursiveZipSearch();
                dir.setLabel(label);
                result.add(dir);
                continue;
            }
            if (ZipFile.isZipFile(f)) {
                ZipFile zip = new ZipFile(f);
                zip.enableRecursiveSearch();
                zip.setLabel(label);
                result.add(zip);
                continue;
            }
            if (!ZipFile.isClassFile(f)) continue;
            SingleFile file = new SingleFile(f);
            file.setLabel(label);
            result.add(file);
        }
        return result.toArray(new IClassList[0]);
    }

    public static List<String> enumerateSystemClasspath() {
        String PATH_SPLIT_REGEX = "\\s*" + File.pathSeparatorChar + "\\s*";
        ArrayList<String> classpath = new ArrayList<String>(1024);
        String classPath = System.getProperty("java.class.path");
        String[] stringArray = classPath.split(PATH_SPLIT_REGEX);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            classpath.add(new File(path).getAbsolutePath());
            ++n2;
        }
        String bootClassPath = System.getProperty("sun.boot.class.path");
        String[] stringArray2 = bootClassPath.split(PATH_SPLIT_REGEX);
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String path = stringArray2[n];
            classpath.add(new File(path).getAbsolutePath());
            ++n;
        }
        String extDirs = System.getProperty("java.ext.dirs");
        String[] stringArray3 = extDirs.split(PATH_SPLIT_REGEX);
        int n4 = stringArray3.length;
        n3 = 0;
        while (n3 < n4) {
            String extDirPath = stringArray3[n3];
            File extDir = new File(extDirPath);
            if (extDir.isDirectory() && extDir.canRead()) {
                File[] extFiles;
                File[] fileArray = extFiles = extDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String lowerFilename = pathname.getAbsolutePath();
                        return lowerFilename.endsWith(".jar") || lowerFilename.endsWith(".zip");
                    }
                });
                int n5 = extFiles.length;
                int n6 = 0;
                while (n6 < n5) {
                    File extFile = fileArray[n6];
                    classpath.add(extFile.getAbsolutePath());
                    ++n6;
                }
            }
            ++n3;
        }
        return classpath;
    }

    public static IClassList[] merge(IClassList[] list1, IClassList[] list2) {
        IClassList[] result = Arrays.copyOf(list1, list1.length + list2.length);
        System.arraycopy(list2, 0, result, list1.length, list2.length);
        return result;
    }
}

