/*
 * Decompiled with CFR 0.152.
 */
package soba.util.files;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import soba.util.files.IClassList;
import soba.util.files.IClassListCallback;
import soba.util.files.ZipFile;

public class Directory
implements IClassList {
    private File dir;
    private String label;
    private boolean searchZip = false;
    private boolean searchZipRecursive = false;
    private boolean autoOpen = true;

    public Directory(File dir) {
        assert (dir.isDirectory()) : String.valueOf(dir.getAbsolutePath()) + " is not a directory.";
        this.dir = dir;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public static Directory[] listSubdirectories(File topDir, int depth) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(topDir);
        int i = 0;
        while (i < depth) {
            ArrayList<File> subdirs = new ArrayList<File>();
            for (File d : dirs) {
                File[] fileArray = d.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory() && !f.getName().equals(".") && !f.getName().equals("..")) {
                        subdirs.add(f);
                    }
                    ++n2;
                }
            }
            dirs = subdirs;
            ++i;
        }
        Directory[] result = new Directory[dirs.size()];
        int i2 = 0;
        while (i2 < dirs.size()) {
            result[i2] = new Directory((File)dirs.get(i2));
            ++i2;
        }
        return result;
    }

    public File getDirectory() {
        return this.dir;
    }

    public void enableZipSearch() {
        this.searchZip = true;
    }

    public void enableRecursiveZipSearch() {
        this.searchZip = true;
        this.searchZipRecursive = true;
    }

    public void disableAutoOpen() {
        this.autoOpen = false;
    }

    @Override
    public void process(IClassListCallback c) {
        FileFilterCallback filter = new FileFilterCallback(c);
        Stack<File> worklist = new Stack<File>();
        worklist.push(this.dir);
        while (!worklist.empty()) {
            File f = (File)worklist.pop();
            if (f.isDirectory()) {
                File[] contents;
                if (!f.exists() || !f.canRead() || (contents = f.listFiles(filter)) == null) continue;
                File[] fileArray = contents;
                int n = contents.length;
                int n2 = 0;
                while (n2 < n) {
                    File content = fileArray[n2];
                    if (!this.dir.equals(content)) {
                        worklist.add(content);
                    }
                    ++n2;
                }
                continue;
            }
            if (f.isFile() && c.isTarget(f.getAbsolutePath()) && f.canRead()) {
                try {
                    if (this.autoOpen) {
                        FileInputStream binaryStream = new FileInputStream(f);
                        c.process(f.getCanonicalPath(), binaryStream);
                        binaryStream.close();
                        continue;
                    }
                    c.process(f.getCanonicalPath(), null);
                    continue;
                }
                catch (IOException e) {
                    boolean stop = c.reportError(f.getAbsolutePath(), e);
                    if (!stop) continue;
                    break;
                }
            }
            if (!ZipFile.isZipFile(f) || !f.canRead()) continue;
            ZipFile zip = new ZipFile(f);
            if (this.searchZipRecursive) {
                zip.enableRecursiveSearch();
            }
            zip.process(c);
        }
    }

    private class FileFilterCallback
    implements FileFilter {
        private IClassListCallback callback;

        public FileFilterCallback(IClassListCallback c) {
            this.callback = c;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || Directory.this.searchZip && ZipFile.isZipFile(f) || f.isFile() && this.callback.isTarget(f.getAbsolutePath());
        }
    }
}

