/*
 * Decompiled with CFR 0.152.
 */
package soba.util.files;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import soba.util.files.IClassList;
import soba.util.files.IClassListCallback;

public class ZipFile
implements IClassList {
    private static final String[] zipExt = new String[]{".jar", ".zip", ".war"};
    private File zip;
    private String label;
    private boolean searchRecursive;

    public static boolean isZipFile(String filename) {
        String lowerFileName = filename.toLowerCase();
        String[] stringArray = zipExt;
        int n = zipExt.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (lowerFileName.endsWith(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isZipFile(File f) {
        return f.isFile() && ZipFile.isZipFile(f.getAbsolutePath());
    }

    public static boolean isClassFile(String filename) {
        String lowerFileName = filename.toLowerCase();
        return lowerFileName.endsWith(".class");
    }

    public static boolean isClassFile(File f) {
        return f.isFile() && ZipFile.isClassFile(f.getAbsolutePath());
    }

    public ZipFile(File zipFile) {
        assert (ZipFile.isZipFile(zipFile));
        this.zip = zipFile;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void enableRecursiveSearch() {
        this.searchRecursive = true;
    }

    @Override
    public void process(IClassListCallback c) {
        try {
            this.processZip(new FileInputStream(this.zip), this.zip.getAbsolutePath(), c, true);
        }
        catch (IOException e) {
            c.reportError(this.zip.getAbsolutePath(), e);
        }
    }

    private void processZip(InputStream stream, String zipFilename, IClassListCallback c, boolean closeStream) {
        ZipInputStream zip = new ZipInputStream(stream);
        String lastEntry = zipFilename;
        try {
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                lastEntry = String.valueOf(zipFilename) + "/" + entry.getName();
                if (c.isTarget(entry.getName())) {
                    c.process(lastEntry, zip);
                } else if (this.searchRecursive && ZipFile.isZipFile(entry.getName())) {
                    this.processZip(zip, lastEntry, c, false);
                }
                zip.closeEntry();
                entry = zip.getNextEntry();
            }
            if (closeStream) {
                zip.close();
            }
        }
        catch (IOException e) {
            c.reportError(lastEntry, e);
        }
        catch (RuntimeException e) {
            c.reportError(lastEntry, e);
        }
    }

    public static class ClassFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File f) {
            return f.isDirectory() || ZipFile.isClassFile(f) || ZipFile.isZipFile(f);
        }
    }
}

