/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import soba.util.graph.DepthFirstSearch;
import soba.util.graph.DirectedGraph;
import soba.util.graph.GraphTestBase;
import soba.util.graph.IDepthFirstVisitor;

public class DepthFirstSearchTest {
    private DirectedGraph graph;

    @Before
    public void buildGraph() throws Exception {
        this.graph = GraphTestBase.buildGraph();
    }

    @Test
    public void testDFS() throws Exception {
        DepthFirstSearch.search(this.graph, 7, new VisitList(new int[]{7, 8, 5, 6, 9, 11, 12, 10}, new int[]{6, 5, 8, 12, 11, 9, 10, 7}));
        DepthFirstSearch.search(this.graph, 7, new VisitList(this, new int[]{7}, new int[]{7}){

            @Override
            protected boolean continueVisit(int vertexId) {
                return false;
            }
        });
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        int[] nArray2 = new int[11];
        nArray2[0] = 2;
        nArray2[1] = 4;
        nArray2[2] = 8;
        nArray2[3] = 9;
        nArray2[4] = 10;
        nArray2[5] = 7;
        nArray2[6] = 6;
        nArray2[7] = 5;
        nArray2[8] = 3;
        nArray2[9] = 1;
        DepthFirstSearch.search(this.graph, 0, new VisitList(this, nArray, nArray2){

            @Override
            protected boolean continueVisit(int vertexId) {
                return vertexId <= 7;
            }
        });
    }

    private class VisitList
    implements IDepthFirstVisitor {
        int[] visitList;
        int[] leaveList;
        boolean[] expectedVisited;
        int visitIndex = 0;
        int leaveIndex = 0;

        public VisitList(int[] visitList, int[] leaveList) {
            int v;
            this.visitList = visitList;
            this.leaveList = leaveList;
            this.expectedVisited = new boolean[DepthFirstSearchTest.this.graph.getVertexCount()];
            int[] nArray = visitList;
            int n = visitList.length;
            int n2 = 0;
            while (n2 < n) {
                v = nArray[n2];
                this.expectedVisited[v] = true;
                ++n2;
            }
            nArray = leaveList;
            n = leaveList.length;
            n2 = 0;
            while (n2 < n) {
                v = nArray[n2];
                Assert.assertThat((Object)this.expectedVisited[v], (Matcher)Matchers.is((Object)true));
                ++n2;
            }
        }

        @Override
        public void onStart(int startVertexId) {
        }

        @Override
        public boolean onVisit(int vertexId) {
            Assert.assertThat((Object)vertexId, (Matcher)Matchers.is((Object)this.visitList[this.visitIndex]));
            ++this.visitIndex;
            return this.continueVisit(vertexId);
        }

        protected boolean continueVisit(int vertexId) {
            return true;
        }

        @Override
        public void onLeave(int vertexId) {
            Assert.assertThat((Object)vertexId, (Matcher)Matchers.is((Object)this.leaveList[this.leaveIndex]));
            ++this.leaveIndex;
        }

        @Override
        public void onFinished(boolean[] visited) {
            int i = 0;
            while (i < visited.length) {
                Assert.assertThat((Object)visited[i], (Matcher)Matchers.is((Object)this.expectedVisited[i]));
                ++i;
            }
        }

        @Override
        public void onVisitAgain(int vertexId) {
            boolean visited = false;
            int i = 0;
            while (i < this.visitIndex) {
                if (this.visitList[i] == vertexId) {
                    visited = true;
                    break;
                }
                ++i;
            }
            Assert.assertThat((Object)visited, (Matcher)Matchers.is((Object)true));
        }
    }
}

