/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import java.util.Arrays;
import soba.util.IntPairProc;
import soba.util.IntPairSet;
import soba.util.IntPairUtil;
import soba.util.IntSetStack;
import soba.util.IntStack;
import soba.util.graph.DirectedGraph;
import soba.util.graph.IDirectedGraph;

public class DirectedAcyclicGraph
implements IDirectedGraph {
    private IDirectedGraph base;
    private int[] sccIds;
    private DirectedGraph dag;
    private TarjanData data;

    public DirectedAcyclicGraph(IDirectedGraph base) {
        this.base = base;
        this.sccIds = new int[base.getVertexCount()];
        this.removeStronglyConnectedComponents();
    }

    private DirectedAcyclicGraph(DirectedAcyclicGraph g) {
        this.base = g.base;
        this.sccIds = g.sccIds;
        this.dag = g.dag;
    }

    @Override
    public int[] getEdges(int memberId) {
        return this.dag.getEdges(memberId);
    }

    @Override
    public int getVertexCount() {
        return this.dag.getVertexCount();
    }

    @Override
    public void forEachEdge(IntPairProc proc) {
        this.dag.forEachEdge(proc);
    }

    public boolean isRepresentativeNode(int vertexId) {
        return this.sccIds[vertexId] == vertexId;
    }

    public int getRepresentativeNode(int vertexId) {
        return this.sccIds[vertexId];
    }

    public DirectedAcyclicGraph getReverseGraph() {
        DirectedAcyclicGraph reverse = new DirectedAcyclicGraph(this);
        reverse.dag = this.dag.getReverseGraph();
        return reverse;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectedAcyclicGraph) {
            DirectedAcyclicGraph another = (DirectedAcyclicGraph)obj;
            if (this.getVertexCount() == another.getVertexCount()) {
                int i = 0;
                while (i < this.getVertexCount()) {
                    if (this.sccIds[i] != another.sccIds[i]) {
                        return false;
                    }
                    if (this.isRepresentativeNode(i)) {
                        int[] to2;
                        int[] to1 = this.getEdges(i);
                        if (to1.length != (to2 = another.getEdges(i)).length) {
                            return false;
                        }
                        int j = 0;
                        while (j < to1.length) {
                            if (to1[j] != to2[j]) {
                                return false;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void removeStronglyConnectedComponents() {
        this.data = new TarjanData();
        int i = 0;
        while (i < this.base.getVertexCount()) {
            if (this.data.visitIndex[i] == -1) {
                this.tarjanDFS(i);
            }
            ++i;
        }
        final IntPairSet dagEdges = new IntPairSet();
        this.base.forEachEdge(new IntPairProc(){

            @Override
            public boolean execute(int elem1, int elem2) {
                int to;
                int from = DirectedAcyclicGraph.this.sccIds[elem1];
                if (from != (to = DirectedAcyclicGraph.this.sccIds[elem2])) {
                    dagEdges.add(from, to);
                }
                return true;
            }
        });
        this.dag = new DirectedGraph(this.base.getVertexCount(), IntPairUtil.createList(dagEdges));
        this.data = null;
    }

    private void tarjanDFS(int vId) {
        this.data.visitIndex[vId] = this.data.currentIndex;
        this.data.lowlink[vId] = this.data.currentIndex++;
        this.data.stack.push(vId);
        int[] nArray = this.base.getEdges(vId);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int to = nArray[n2];
            if (this.data.visitIndex[to] == -1) {
                this.tarjanDFS(to);
                this.data.lowlink[vId] = Math.min(this.data.lowlink[vId], this.data.lowlink[to]);
            } else if (this.data.stack.contains(to)) {
                this.data.lowlink[vId] = Math.min(this.data.lowlink[vId], this.data.visitIndex[to]);
            }
            ++n2;
        }
        if (this.data.lowlink[vId] == this.data.visitIndex[vId]) {
            int pop;
            do {
                pop = this.data.stack.pop();
                this.sccIds[pop] = vId;
            } while (pop != vId);
        }
    }

    private class TarjanData {
        public int currentIndex = 0;
        public int[] visitIndex;
        public int[] lowlink;
        public IntStack stack;

        public TarjanData() {
            this.visitIndex = new int[DirectedAcyclicGraph.this.base.getVertexCount()];
            this.lowlink = new int[DirectedAcyclicGraph.this.base.getVertexCount()];
            this.stack = new IntSetStack(DirectedAcyclicGraph.this.base.getVertexCount());
            Arrays.fill(this.visitIndex, -1);
        }
    }
}

