/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import soba.util.IntPairList;
import soba.util.IntPairProc;
import soba.util.graph.GraphUtil;
import soba.util.graph.IDirectedGraph;

public class DirectedGraph
implements IDirectedGraph {
    private int vertexCount;
    private int edgeCount;
    private IntPairList edges;
    private int[][] forward;
    private static final int[] EMPTY_ARRAY = new int[0];

    public DirectedGraph(int vertexCount, IntPairList edges) {
        this.vertexCount = vertexCount;
        this.edges = edges;
        this.edgeCount = edges.size();
        this.edges.sort();
        this.forward = this.constructEdgeArray(edges);
    }

    private int[][] constructEdgeArray(IntPairList edges) {
        TIntHashSet[] forwardTemp = new TIntHashSet[this.vertexCount];
        int i = 0;
        while (i < edges.size()) {
            int from = edges.getFirstValue(i);
            int to = edges.getSecondValue(i);
            if (forwardTemp[from] == null) {
                forwardTemp[from] = new TIntHashSet(2);
            }
            forwardTemp[from].add(to);
            ++i;
        }
        int[][] forward = new int[this.vertexCount][];
        int i2 = 0;
        while (i2 < this.vertexCount) {
            if (forwardTemp[i2] != null) {
                int[] array = forwardTemp[i2].toArray();
                Arrays.sort(array);
                forward[i2] = array;
            } else {
                forward[i2] = EMPTY_ARRAY;
            }
            ++i2;
        }
        return forward;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    public void forEachEdge(IntPairProc proc) {
        this.edges.foreach(proc);
    }

    @Override
    public int[] getEdges(int memberId) {
        return this.forward[memberId];
    }

    public DirectedGraph getReverseGraph() {
        return GraphUtil.getReverseGraph(this);
    }

    public DirectedGraph getUndirectedGraph() {
        return GraphUtil.getUndirectedGraph(this);
    }
}

