/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import gnu.trove.list.array.TIntArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import soba.util.UtilForAssertThat;
import soba.util.graph.DepthFirstSearch;
import soba.util.graph.DirectedGraph;
import soba.util.graph.GraphTestBase;
import soba.util.graph.IDepthFirstVisitor;

public class DirectedGraphTest {
    private static DirectedGraph graph;

    @BeforeClass
    public static void buildGraph() {
        graph = GraphTestBase.buildGraph();
    }

    @Test
    public void testDepthFirstSearch() throws Exception {
        final TIntArrayList visited = new TIntArrayList();
        DepthFirstSearch.search(graph, 0, new IDepthFirstVisitor(){

            @Override
            public void onStart(int startVertexId) {
            }

            @Override
            public boolean onVisit(int vertexId) {
                visited.add(vertexId);
                return true;
            }

            @Override
            public void onLeave(int vertexId) {
            }

            @Override
            public void onFinished(boolean[] visited2) {
                Assert.assertThat((Object)visited2.length, (Matcher)Matchers.is((Object)14));
                int i = 0;
                while (i < 13) {
                    Assert.assertThat((Object)visited2[i], (Matcher)Matchers.is((Object)true));
                    ++i;
                }
                Assert.assertThat((Object)visited2[13], (Matcher)Matchers.is((Object)false));
            }

            @Override
            public void onVisitAgain(int vertexId) {
                Assert.assertThat((Object)visited.contains(vertexId), (Matcher)Matchers.is((Object)true));
            }
        });
        Assert.assertThat((Object)visited.size(), (Matcher)Matchers.is((Object)13));
    }

    @Test
    public void testEdgeCount() {
        Assert.assertThat((Object)graph.getEdgeCount(), (Matcher)Matchers.is((Object)16));
    }

    @Test
    public void testReverseGraph() {
        DirectedGraph r = graph.getReverseGraph();
        Assert.assertThat((Object)r.getVertexCount(), (Matcher)Matchers.is((Object)14));
        Assert.assertThat((Object)r.getEdgeCount(), (Matcher)Matchers.is((Object)16));
        Integer[] edgesFrom0 = UtilForAssertThat.asIntegerArray(r.getEdges(0));
        Assert.assertThat((Object)edgesFrom0, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{2})));
        Integer[] edgesFrom1 = UtilForAssertThat.asIntegerArray(r.getEdges(1));
        Assert.assertThat((Object)edgesFrom1, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{0})));
        Integer[] edgesFrom2 = UtilForAssertThat.asIntegerArray(r.getEdges(2));
        Assert.assertThat((Object)edgesFrom2, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1})));
        Integer[] edgesFrom3 = UtilForAssertThat.asIntegerArray(r.getEdges(3));
        Assert.assertThat((Object)edgesFrom3, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{1})));
        Integer[] edgesFrom4 = UtilForAssertThat.asIntegerArray(r.getEdges(4));
        Assert.assertThat((Object)edgesFrom4, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{3})));
        Integer[] edgesFrom5 = UtilForAssertThat.asIntegerArray(r.getEdges(5));
        Assert.assertThat((Object)edgesFrom5, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{3, 8})));
        Integer[] edgesFrom6 = UtilForAssertThat.asIntegerArray(r.getEdges(6));
        Assert.assertThat((Object)edgesFrom6, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{5})));
        Integer[] edgesFrom7 = UtilForAssertThat.asIntegerArray(r.getEdges(7));
        Assert.assertThat((Object)edgesFrom7, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{6})));
        Integer[] edgesFrom8 = UtilForAssertThat.asIntegerArray(r.getEdges(8));
        Assert.assertThat((Object)edgesFrom8, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{6, 7})));
        Integer[] edgesFrom9 = UtilForAssertThat.asIntegerArray(r.getEdges(9));
        Assert.assertThat((Object)edgesFrom9, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{7})));
        Integer[] edgesFrom10 = UtilForAssertThat.asIntegerArray(r.getEdges(10));
        Assert.assertThat((Object)edgesFrom10, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{7})));
        Integer[] edgesFrom11 = UtilForAssertThat.asIntegerArray(r.getEdges(11));
        Assert.assertThat((Object)edgesFrom11, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{9, 10})));
        Integer[] edgesFrom12 = UtilForAssertThat.asIntegerArray(r.getEdges(12));
        Assert.assertThat((Object)edgesFrom12, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{11})));
        Integer[] edgesFrom13 = UtilForAssertThat.asIntegerArray(r.getEdges(13));
        Assert.assertThat((Object)edgesFrom13, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
    }

    @Test
    public void testUndirectedGraph() {
        DirectedGraph g = graph.getUndirectedGraph();
        Integer[] edgesFrom1 = UtilForAssertThat.asIntegerArray(g.getEdges(1));
        Assert.assertThat((Object)edgesFrom1, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{0, 2, 3})));
        Integer[] edgesFrom10 = UtilForAssertThat.asIntegerArray(g.getEdges(10));
        Assert.assertThat((Object)edgesFrom10, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{7, 11})));
        Integer[] edgesFrom12 = UtilForAssertThat.asIntegerArray(g.getEdges(12));
        Assert.assertThat((Object)edgesFrom12, (Matcher)Matchers.is((Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Integer[]{11})));
        Integer[] edgesFrom13 = UtilForAssertThat.asIntegerArray(g.getEdges(13));
        Assert.assertThat((Object)edgesFrom13, (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        Assert.assertThat((Object)g.getEdgeCount(), (Matcher)Matchers.is((Object)32));
    }
}

