/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import soba.util.graph.DepthFirstSearch;
import soba.util.graph.IDepthFirstVisitor;
import soba.util.graph.IDirectedGraph;
import soba.util.graph.SingleRootDirectedGraph;

public class DominanceTree {
    private SingleRootDirectedGraph base;
    private IDirectedGraph reverse;
    private int[] reversePostOrder;
    private int[] immediateDominator;

    public DominanceTree(SingleRootDirectedGraph graph) {
        this.base = graph;
        this.reverse = graph.getReverseGraph();
        this.reversePostOrder = new int[this.base.getVertexCount()];
        this.immediateDominator = new int[this.base.getVertexCount()];
        this.computeSpanningTree();
        this.computeDominators();
    }

    public boolean isRoot(int vertexID) {
        return vertexID == this.base.getRootId();
    }

    public int getDominator(int vertexID) {
        return this.immediateDominator[vertexID];
    }

    private void computeSpanningTree() {
        DepthFirstSearch.search(this.base, this.base.getRootId(), new IDepthFirstVisitor(){
            private int reversePostOrderIndex;
            {
                this.reversePostOrderIndex = DominanceTree.this.base.getVertexCount() - 1;
            }

            @Override
            public void onStart(int startVertexId) {
            }

            @Override
            public boolean onVisit(int vertexId) {
                return true;
            }

            @Override
            public void onLeave(int vertexId) {
                ((DominanceTree)DominanceTree.this).reversePostOrder[vertexId] = this.reversePostOrderIndex--;
            }

            @Override
            public void onFinished(boolean[] visited) {
            }

            @Override
            public void onVisitAgain(int vertexId) {
            }
        });
    }

    private void computeDominators() {
        int n;
        int n2;
        int[] nArray;
        int[] sortedVertices = new int[this.base.getVertexCount()];
        int i = 0;
        while (i < this.base.getVertexCount()) {
            sortedVertices[this.reversePostOrder[i]] = i;
            ++i;
        }
        int from = 0;
        while (from < this.base.getVertexCount()) {
            nArray = this.base.getEdges(from);
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                int to = nArray[n];
                if (this.reversePostOrder[from] < this.reversePostOrder[to]) {
                    this.immediateDominator[to] = from;
                }
                ++n;
            }
            ++from;
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            nArray = sortedVertices;
            n2 = sortedVertices.length;
            n = 0;
            while (n < n2) {
                int v = nArray[n];
                int[] pred = this.reverse.getEdges(v);
                int idx = 0;
                while (idx < pred.length) {
                    int idom = this.immediateDominator[v];
                    int nca = this.nearestCommonAncestor(idom, pred[idx]);
                    if (idom != nca) {
                        changed = true;
                        this.immediateDominator[v] = nca;
                    }
                    ++idx;
                }
                ++n;
            }
        }
    }

    public final int nearestCommonAncestor(int v1, int v2) {
        while (v1 != v2) {
            int i1 = this.reversePostOrder[v1];
            int i2 = this.reversePostOrder[v2];
            if (i1 > i2) {
                v1 = this.immediateDominator[v1];
                continue;
            }
            assert (i1 < i2) : "v1!=v2 implies i1!=i2";
            v2 = this.immediateDominator[v2];
        }
        return v1;
    }
}

