/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import soba.util.graph.DirectedGraph;
import soba.util.graph.DominanceTree;
import soba.util.graph.GraphTestBase;
import soba.util.graph.SingleRootDirectedGraph;

public class DominanceTreeTest {
    private static DirectedGraph graph;

    @BeforeClass
    public static void buildGraph() throws Exception {
        graph = GraphTestBase.buildGraph();
    }

    @Test
    public void testDominanceTree() {
        SingleRootDirectedGraph g = new SingleRootDirectedGraph(graph);
        DominanceTree tree = new DominanceTree(g);
        Assert.assertThat((Object)tree.isRoot(g.getRootId()), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)tree.isRoot(0), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)tree.isRoot(13), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)tree.getDominator(0), (Matcher)Matchers.is((Object)14));
        Assert.assertThat((Object)tree.getDominator(1), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)tree.getDominator(2), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)tree.getDominator(3), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)tree.getDominator(4), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)tree.getDominator(5), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)tree.getDominator(6), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)tree.getDominator(7), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)tree.getDominator(8), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)tree.getDominator(9), (Matcher)Matchers.is((Object)7));
        Assert.assertThat((Object)tree.getDominator(10), (Matcher)Matchers.is((Object)7));
        Assert.assertThat((Object)tree.getDominator(11), (Matcher)Matchers.is((Object)7));
        Assert.assertThat((Object)tree.getDominator(12), (Matcher)Matchers.is((Object)11));
        Assert.assertThat((Object)tree.getDominator(13), (Matcher)Matchers.is((Object)14));
        Assert.assertThat((Object)tree.nearestCommonAncestor(1, 13), (Matcher)Matchers.is((Object)14));
        Assert.assertThat((Object)tree.nearestCommonAncestor(5, 12), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)tree.nearestCommonAncestor(4, 12), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)tree.nearestCommonAncestor(12, 4), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)tree.nearestCommonAncestor(8, 6), (Matcher)Matchers.is((Object)6));
    }
}

