/*
 * Decompiled with CFR 0.152.
 */
package soba.util.graph;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import soba.util.IntPairProc;
import soba.util.graph.DirectedGraph;
import soba.util.graph.GraphTestBase;
import soba.util.graph.SingleRootDirectedGraph;

public class SingleRootDirectedGraphTest {
    private DirectedGraph graph;

    @Before
    public void buildGraph() throws Exception {
        this.graph = GraphTestBase.buildGraph();
    }

    @Test
    public void testSingleRootDirectedGraph() throws Exception {
        SingleRootDirectedGraph base = new SingleRootDirectedGraph(this.graph);
        Assert.assertThat((Object)base.getVertexCount(), (Matcher)Matchers.is((Object)15));
        Assert.assertThat((Object)base.getRootId(), (Matcher)Matchers.is((Object)14));
        Assert.assertThat((Object)base.getEdges(14).length, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)base.getEdges(14)[0], (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)base.getEdges(14)[1], (Matcher)Matchers.is((Object)13));
    }

    @Test
    public void testEdges() throws Exception {
        final SingleRootDirectedGraph base = new SingleRootDirectedGraph(this.graph);
        base.forEachEdge(new IntPairProc(){
            int index = 0;
            int[][] expected;
            {
                int[][] nArrayArray = new int[18][];
                int[] nArray = new int[2];
                nArray[1] = 1;
                nArrayArray[0] = nArray;
                nArrayArray[1] = new int[]{1, 2};
                nArrayArray[2] = new int[]{1, 3};
                int[] nArray2 = new int[2];
                nArray2[0] = 2;
                nArrayArray[3] = nArray2;
                nArrayArray[4] = new int[]{3, 4};
                nArrayArray[5] = new int[]{3, 5};
                nArrayArray[6] = new int[]{5, 6};
                nArrayArray[7] = new int[]{6, 7};
                nArrayArray[8] = new int[]{6, 8};
                nArrayArray[9] = new int[]{7, 8};
                nArrayArray[10] = new int[]{7, 9};
                nArrayArray[11] = new int[]{7, 10};
                nArrayArray[12] = new int[]{8, 5};
                nArrayArray[13] = new int[]{9, 11};
                nArrayArray[14] = new int[]{10, 11};
                nArrayArray[15] = new int[]{11, 12};
                int[] nArray3 = new int[2];
                nArray3[0] = 14;
                nArrayArray[16] = nArray3;
                nArrayArray[17] = new int[]{14, 13};
                this.expected = nArrayArray;
            }

            @Override
            public boolean execute(int elem1, int elem2) {
                Assert.assertThat((Object)elem1, (Matcher)Matchers.is((Object)this.expected[this.index][0]));
                Assert.assertThat((Object)elem2, (Matcher)Matchers.is((Object)this.expected[this.index][1]));
                ++this.index;
                return true;
            }
        });
        base.forEachEdge(new IntPairProc(){
            private boolean first = true;

            @Override
            public boolean execute(int elem1, int elem2) {
                if (this.first) {
                    this.first = false;
                    return false;
                }
                Assert.fail();
                return false;
            }
        });
        base.forEachEdge(new IntPairProc(){
            private boolean firstFromRoot = true;

            @Override
            public boolean execute(int elem1, int elem2) {
                if (base.getRootId() == elem1) {
                    if (this.firstFromRoot) {
                        this.firstFromRoot = false;
                        return false;
                    }
                    Assert.fail();
                    return false;
                }
                return true;
            }
        });
    }
}

