<?php
class WatchListAddFormlet {

  function show() {
    global $request;
    if (!WebSession::isLogined() || !isset($request['name']))
      return;
    $pageName = $request['name'];
    check_pagename($pageName);
    print '<form action="index.php" method="post">';
    print '<input type="hidden" name="action" value="addtowatchlist">';
    print '<input type="hidden" name="name" value="';
    print htmlspecialchars($pageName);
    print '">';
    print '<input type="submit" value="Watch">';
    print '</form>';
  }

  function action($params) {
    WebSession::isLogined() or die('not logged in');
    $userName = WebSession::loginUserName();
    $pageName = $params['name'];
    check_pagename($pageName);
    $watchList = ListData::open($userName, 'watchlist');
    if ($watchList->add($pageName, true)) {
      if (WebSession::isUserName($pageName)) {
        $watchedList = ListData::open($pageName, 'watchedlist');
        $watchedList->add($userName, true);
        ListData::close($watchedList);
      }
      $result = 'WatchListɲäޤ';
    }
    else {
      $result = 'WatchListϿƤޤ';
    }
    ListData::close($watchList);
    $url = 'index.php?mod=WikiView&name=' . htmlspecialchars(urlencode($pageName));
    redirect_to($url, $result, 0);
  }
}

class WatchListEditFormlet {

  function show() {
    WebSession::isLogined() or die('not logged in');
    $userName = WebSession::loginUserName();
    $watchList = ListData::open($userName, 'watchlist');
    $text = $watchList->getRaw();
    ListData::close($watchList);
    ?>
    <form action="index.php" method="post">
      <input type="hidden" name="action" value="watchlistedit">
       <textarea name="content" cols="80" rows="25"><?php echo htmlspecialchars($text); ?></textarea><br>
      <input type="submit" value="Save">
      <input type="reset" value="Reset">
    </form>
    <?php
  }

  function action($params) {
    WebSession::isLogined() or die('not logged in');
    $userName = WebSession::loginUserName();
    // TODO: make atomic
    $watchList = ListData::open($userName, 'watchlist');
    $oldList = $watchList->get();
    $watchList->putRaw($params['content']);
    $newList = $watchList->get();
    ListData::close($watchList);
    foreach(array_diff($oldList, $newList) as $toRemove) {
      if (!WebSession::isUserName($toRemove))
        continue;
      $watchedList = ListData::open($toRemove, 'watchedlist');
      $watchedList->remove($userName);
      ListData::close($watchedList);
    }
    foreach(array_diff($newList, $oldList) as $toAdd) {
      if (!WebSession::isUserName($toAdd))
        continue;
      $watchedList = ListData::open($toAdd, 'watchedlist');
      $watchedList->add($userName, true);
      ListData::close($watchedList);
    }
    redirect_to('index.php?mod=WatchListEdit', '񤭹ߤޤ', 0);
  }
}

class WatchListViewFormlet {

  function show() {
    if(!WebSession::isLogined()) return;

    $userName = WebSession::loginUserName();
    $pages = array_map(array("WikiPageStorage", "pageName"), WikiPageStorage::allFiles());

    $watchList = ListData::open($userName, 'watchlist');
    $targets =& new TargetList($watchList->get());
    ListData::close($watchList);

    $isTargetAction = array(&$targets, 'isTargetAction');
    $list = WatchListViewFormlet::getRecentActions($pages, $isTargetAction, $targets);
    WatchListViewFormlet::printList($list);
  }

  function printList($list) {
    foreach (array_slice($list, 0, DEFAULT_RECENT_LIST_NUMBER) as $data) {
      list($page, $time, $action, $user) = $data;
      WatchListViewFormlet::printItem($page, $time, $action, $user);
    }
  }

  function printItem($page, $time, $action, $user) {
    $time = date('Y-m-d H:i:s', $time);
    $pageAnchor = Formatter::linkToPage($page);
    if (WebSession::isUserName($page)) {
      $pageAnchor = '<span class="user">' . $pageAnchor . '</span>';
    }
    $user = Formatter::linkToPageIfUserExists($user);
    print "$time - $pageAnchor ($action by $user)<br>\n";
  }

  function getRecentActions($pages, $pred) {
    $property = Property::instanceReadOnly();
    $result = array();
    foreach ($pages as $page) {
      $mo = $property->get($page, 'last_modified_user');
      $co = $property->get($page, 'last_commented_user');
      $mt = $mo ? WatchListViewFormlet::getLastModifiedTime($page) : 0;
      $ct = $co ? WatchListViewFormlet::getLastCommentedTime($page) : 0;
      if ($mt < $ct) {
        if (call_user_func($pred, $page, $ct, 'commented', $co))
          $result[$ct] = array($page, $ct, 'commented', $co);
        else if ($mt && call_user_func($pred, $page, $mt, 'modified', $mo))
          $result[$mt] = array($page, $mt, 'modified', $mo);
      }
      else {
        if ($mt && call_user_func($pred, $page, $mt, 'modified', $mo))
          $result[$mt] = array($page, $mt, 'modified', $mo);
        else if ($ct && call_user_func($pred, $page, $ct, 'commented', $co))
          $result[$ct] = array($page, $ct, 'commented', $co);
      }
    }
    krsort($result);
    return $result;
  }

  function getLastModifiedTime($name) {
    return filemtime(WatchListViewFormlet::pagePath($name));
  }

  function getLastCommentedTime($name) {
    return filemtime(WatchListViewFormlet::commentPath($name));
  }

  function pagePath($name) {
    return WikiPageStorage::filePath($name);
  }

  function commentPath($name) {
    return WikiCommentStorage::filePath($name);
  }
}

class WatchedListViewFormlet {

  function show() {
    WebSession::isLogined() or die('not logged in');
    $userName = WebSession::loginUserName();
    $watchedList = ListData::open($userName, 'watchedlist');
    foreach ($watchedList->get() as $watcher) {
      print '['.Formatter::linkToPage($watcher).'] ';
    }
    ListData::close($watchList);
  }
}

class TargetList {

  var $list;

  function TargetList($list) {
    $this->list = $list;
  }

  function isTargetAction($page, $time, $action, $user) {
    return in_array($page, $this->list) || in_array($user, $this->list, true);
  }
}

class ListData {

  var $user;
  var $key;

  function ListData($user, $key) {
    WikiPageStorage::checkSlash($user);
    WikiPageStorage::checkSlash($key);
    $this->user = $user;
    $this->key = $key;
  }

  function &open($user, $key) {
    $obj = new ListData($user, $key);
    return $obj;
  }

  function close(&$listData) {
  }

  function contains($item, $strict=false) {
    return in_array($item, $this->get(), $strict);
  }

  function get() {
    $raw = $this->getRaw();
    return ($raw != '') ? explode("\n", $raw) : array();
  }

  function put($list) {
    $this->putRaw(join("\n", $list));
  }

  function replace($callback) {
    $file = $this->filePath();
    $mode = $this->exists() ? 'r+' : 'w+';
    $fp = fopen($file, $mode) or die('file open error');
    flock($fp, LOCK_EX);
    $args = array_slice(func_get_args(), 1);
    $size = filesize($file);
    if ($size) {
      $raw = fread($fp, $size);
      $args[] = explode("\n", $raw);
    }
    else {
      $args[] = array();
    }

    $list = call_user_func_array($callback, $args);
    if (!is_array($list))
      return false;
    $content = implode("\n", $list);
    fseek($fp, 0);
    if (is_integer($length = fwrite($fp, $content))) {
      ftruncate($fp, $length);
      fflush($fp);
    }
    flock($fp, LOCK_UN);
    fclose($fp);
    return true;
  }

  function add($toAdd, $keepUnique) {
    $callback = array('ListData', 'addCallback');
    return $this->replace($callback, $toAdd, $keepUnique);
  }

  function addCallback($toAdd, $keepUnique, $list) {
    if ($keepUnique && in_array($toAdd, $list))
      return false;
    $list[] = $toAdd;
    return $list;
  }

  function remove($toRemove) {
    $callback = array('ListData', 'removeCallback');
    return $this->replace($callback, $toRemove);
  }

  function removeCallback($toRemove, $list) {
    $found = false;
    while (is_integer($index = array_search($toRemove, $list))) {
      $found = true;
      array_splice($list, $index, 1);
    }
    return $found ? $list : false;
  }

  function getRaw() {
    if (!$this->exists())
      return '';
    return join('', file($this->filePath()));
  }

  function putRaw($text) {
    $file = $this->filePath();
    $fp = fopen($file, 'w') or die('file open error');
    fputs($fp, $this->normalizeLinefeed($text));
    fflush($fp);
    fclose($fp);
  }

  function exists() {
    return file_exists($this->filePath());
  }

  function filePath() {
    $path = WikiPageStorage::metaDataDir($this->user) . '/' . basename($this->key) . '.txt';
    return $path;
  }

  function normalizeLinefeed($text) {
    $text = str_replace("\r\n", "\n", $text);
    $text = str_replace("\r", "\n", $text);
    return $text;
  }
}

?>
