# -*- coding: utf-8 -*-
class UsersController < ApplicationController
  skip_before_filter :authorize, only: [:new, :create]

  def new
    @user = User.new

    respond_to do |format|
      format.html
      format.json { render json: @user }
    end
  end

  def create
    if params[:language]
      redirect_to new_user_url(locale: params[:language][:locale])
      return
    end

    @user = User.new(params[:user])

    # en 以外のロケールが利用されているときは、そのロケールでユーザを作成する
    unless I18n.locale == 'en'
      @user.locale = I18n.locale
    end

    # 設定に依存して、登録した時点でユーザを有効にさせる
    default_config = DefaultConfig.all.first
    unless default_config.is_user_activate_manually
      @user.is_active = true
    end

    respond_to do |format|
      if @user.save
        format.html { redirect_to login_url,
          notice: t('notice.messages.handle_created', handle: @user.handle) }
        format.json { render json: @user, status: :created, location: @user }
      else
        format.html { render action: "new" }
        format.json { render json: @user.errors, status: :unprocessable_entity }
      end
    end
  end

  def show
    if params[:order]
      @user.project_order_csv = params[:order]
      @user.save()

      @projects = Project.belongs_projects(@user)
      @order_projects = Project.create_order_projects(@projects)
      @changed_id = params[:changed_id]

      # projects_url からの遷移とみなす
      respond_to do |format|
        format.html { redirect_to projects_url }
        format.js { render template: 'projects/update_order' }
      end
    end
  end


  def update
    user = User.find(params[:id])

    if params[:user][:current_password]
      # user_url からの遷移とみなす
      is_changed, message =
        change_password(@user, @user,
                        params[:user][:current_password],
                        params[:user][:new_password],
                        params[:user][:new_password_confirm])

      if is_changed
        redirect_to edit_user_url(id: user.id), notice: message
      else
        redirect_to edit_user_url(id: user.id), alert: message
      end
      return
    end

    respond_to do |format|
      if user.update_attributes(params[:user])
        if params[:user].has_key?(:is_resolved_show)
          # ticket_url からの遷移とみなす
          format.html { redirect_to tickets_url }
        else
          # user_url からの遷移とみなす
          format.html { redirect_to edit_user_url(id: user.id,
                                                    locale: user.locale) }
        end
        format.json { head :ok }
      else
        format.html { render action: "edit" }
        format.json { render json: @order.errors,
          status: :unprocessable_entity }
      end
    end
  end

  def edit
    user_id = session[:user_id]
    @user = User.find(user_id)
  end
end
