class CreateUsers < ActiveRecord::Migration
  def change
    create_table :users do |t|
      t.string :email
      t.string :password_digest
      t.string :confirmation_token
      t.datetime :confirmation_at, default: nil

      t.string :handle
      t.boolean :is_active, default: false
      t.boolean :is_admin, default: false

      t.boolean :is_resolved_show, default: false

      t.string :locale, default: 'en'
      t.string :timezone, default: nil
      t.string :project_order_csv, default: ''

      t.timestamps
    end
  end
end
