require 'test_helper'

class SessionsControllerTest < ActionController::TestCase
  test "should get new" do
    get :new
    assert_response :success
  end

  test "should login" do
    person = users(:one)
    post :create, email: person.email, password: 'secret'
    assert_redirected_to tickets_url locale: 'en'
    assert_equal person.id, session[:user_id]
  end

  test "should fail login" do
    person = users(:one)
    post :create, email: person.email, password: 'wrong'
    assert_redirected_to login_url
  end

  test "should logout" do
    delete :destroy
    assert_redirected_to login_url
  end
end
