
program = {
  comment:  "file copy in soopy2";
  author:   "$Author: randy $";
  date:     "$Date: 2002/12/14 11:49:38 $";
  revision: "$Revision: 1.3 $";

  fun usage(){
    do: println "usage: soopy cp.sp src_file dist_file";
  };

  fun with_openIn_file(filename, body){
    comment: "open input-file & eval body & close file";
    var: [fin];
    do: [
      fin = openIn filename;
      body eval(fin);
      fin close;
    ];
    rescue: fin close;
  };

  fun with_openOut_file(filename, body){
    comment: "open output-file & eval body & close file";
    var: [fout];
    do: [
      fout = openOut filename;
      body eval(fout);
      fout close;
    ];
    rescue: fout close;
  };

  fun copy(src, dist){
    comment: "copy file from src to dist";
    do: with_openIn_file src {
          arg: [fin];
          var: [ch];
          do: [
                with_openOut_file dist {
                  arg: [fout];
                  do: [
                    loop {
                      from: ch = fin readChar;
                      step: ch = fin readChar;
                      until: fin eof?;
                      do: fout writeChar ch;
                    };
                  ];
                };
              ];
        };
  };

  /*
   * Main routine
   */
  fun main(){
    comment: "main routine";
    var: [files];
    do: [
      files = Soopy commandLine;
      if(files){
        [x,y]: copy(x,y);
        _:     usage();
      };
    ];
  };
};

program main();

