#!/home/jun/bin/soopy
#!/usr/local/bin/soopy
#
# SoopyWiki Version 1.0
#
# wiki.cgi
#
# Copyright (C) 2003 by SUZUKI Jun.
# <randy@users.sourceforge.jp>
# http://soopy.sourceforge.jp/
#
# $Id: wiki.cgi,v 1.22 2003/03/13 13:53:56 randy Exp $
#

  #########################
  # 
  #########################

  dbdir      = "spwiki/";
  thisurl    = "wiki.cgi";  # ΣãǣɤΥե̾
  frontpage  = "FrontPage"; # FrontPageɽ̾
  indexpage  = "Index";     # IndexΥȥ̾
  errorpage  = "Error";     # ErrorΥȥ̾
  naviwrite  = "Write";     # WriteΥȥ̾
  naviedit   = "Edit";      # EditΥʥӥɽ̾
  naviindex  = "Index";     # IndexΥʥӥɽ̾
  msgdeleted = " is deleted.";
  editchar   = "?";
  cols = 80;                 # EditΥƥȥꥢη
  rows = 20;                 # EditΥƥȥꥢιԿ
  titlecolor = "#F0E0E7";   # Wikiȥο
  bgcolor    = "white";     # background
  style = "
<style type=\"text/css\">
<!--
pre     { line-height: 130% }
a       {}
a:hover {
          color: red;
          background-color: white;
          text-decoration: underline
        }
h2      { text-align: left;
          border: #b9a 1px solid;
          color: black;
          background: #f0e0e7;
          padding: .1em .5em .1em .5em;
        }
h3      { text-align: left;
          border-bottom: #b9a 1px solid;
          color: black;
          background: #f0e0e7;
          padding: .1em .5em .1em .5em;
        }
-->
</style>
";  # 롡ޤ

  #####################
  # ꡡޤ
  #####################

  # contenttype = "Content-type: text/html; charset=Shift_JIS";
  contenttype = "Content-type: text/html; charset=euc-jp";
  KANJI_ENCODER = Japanese;


  /*
   * utility routines
   */

  fun with_openIn_file(filename, body){
    comment: "open input-file & eval body & close file";
    var: [fin];
    do: [
      fin = openIn filename;
      body eval(fin);
      fin close;
    ];
    rescue: [
      if(fin isNil?){
        false: fin close;
      };
    ];
  };

  fun with_openOut_file(filename, body){
    comment: "open output-file & eval body & close file";
    var: [fout];
    do: [
      fout = openOut filename;
      body eval(fout);
      fout close;
    ];
    rescue: [
      if(fout isNil?){
        false: fout close;
      };
    ];
  };

  fun add_line(x, y){
    do: x + "\n" + y;
  };

/*
 * Main Object
 */
{
  /*
   * variables
   */
  form:     {};
  database: nil;

  /*
   * Databse
   */

  db: {
   private

    index_file: "wiki.index";
    index: {}; # key: WikiName, value: Version

    fun find(key){
      var: [str, ver];
      do: [
        ver = index lookup key;
        if(ver isNil?){
          true: ("", false);
          false: [
            with_openIn_file (dbdir + key + "." + ver) {
              arg: [fin];
              var: [list];
              do: [
                list = fin readLines;
                str = list foldl add_line;
              ];
            };
            (str, true);
          ];
        };
      ];
    };

    fun append_index(filename:string){
      var: [name, ext];
      do: [
        name = "";
        if(filename split('.')){
          [x,y]: [
            name = x;
            ext = y;
            index append name ext;
          ];
        };
      ];
    };

    fun update_version(key, ver, old){
      do: [
        if(old split '.'){
          [x,y]: [
            if(x == key){
              true: [
                key + "." + ver;
              ];
              false: [
                old;
              ];
            };
          ];
        };
      ];
    };

    fun update_index(key:string, ver:string){
      var: [idx];
      do: [
        with_openIn_file (dbdir + index_file) {
          arg: [fin];
          do: [
            idx = fin readlines;
            if((index lookup key) isNil?){
              true: idx = (key + "." + ver) :: idx;
              false: idx = idx map (update_version key ver);
            };
          ];
        };
        with_openOut_file (dbdir + index_file) {
          arg: [fout];
          do: [
            fout writelines idx;
          ];
        };
        # update var 'index'
        index = {};
        idx map append_index;
      ];
    };

   public

    fun cut_ext(filename:string){
      var: [name, ext];
      do: [
        name = "";
        if(filename split('.')){
          x::xs: [name = x];
        };
        name;
      ];
    };

    fun get_keys(){
      var: [dlist];
      do: [
        dlist = index keys;
        dlist map cut_ext;
      ];
    };

    fun not_eq_key(key, key2){
      var: [name, ext];
      do: [
        if(key2 split('.')){
          [name, ext]: key != name;
          _: true;
        }
      ];
    };

    fun delete(key){
      var: [idx];
      do: [
        with_openIn_file (dbdir + index_file) {
          arg: [fin];
          do: [
            idx = fin readlines;
            idx = idx filter (not_eq_key key);
          ];
        };
        with_openOut_file (dbdir + index_file) {
          arg: [fout];
          do: [
            fout writelines idx;
          ];
        };
        # update var 'index'
        index = {};
        idx map append_index;
      ];
    };

    fun set(key, value){
      var: [ver, filename];
      do: [
        ver = index lookup key;
        if(ver isNil?){
          true: [
            ver = "001";
          ];
          false: [
            ver = (ver toInt + 1) toString;
          ];
        };
        filename = key + "." + ver;
        with_openOut_file (dbdir + filename) {
          arg: [fout];
          do: [
            fout write value;
            update_index(key, ver);
          ];
        };
      ];
    };

    fun get(key){
      var: [found, str];
      do: [
        let (str, found) = find key;
        if(found){
          true:  str;
          false: "";
        };
      ];
    };

    fun open(){
      var: [filelist];
      do: [
        with_openIn_file (dbdir + index_file) {
          arg: [fin];
          do: [
            filelist = fin readlines;
            filelist map append_index;
          ];
        };
      ];
    };

    fun close(){
    };

  }; /* end db */


  /*
   * Main Program
   */

  fun init_form(){
    var: [query, pairs];
    do: [
      if(Env "REQUEST_METHOD"){
        "GET":  [query = Env "QUERY_STRING"];
        "POST": [query = STDIN read(Env "CONTENT_LENGTH" toInt)];
      };
      pairs = query split('&');
      pairs each {
        arg: [pair];
        local: [key, value, reader];
        do: [
          if(pair split('=')){
            [k, v]: [key = k; value = v;];
          };
          value = value tr '+' ' ';
          reader = value reader; # get string reader;
          reader = URLencoder decoderIn reader;
          reader = CRLF2LF encoderIn reader;
          reader = KANJI_ENCODER encoderIn reader;
          value = reader readlines;
          if(value isNil?){
            true:  value = "";
            false: value = value foldl add_line;
          };
          form append (key, value);
        ];
      };
    ];
  };

  fun make_link(url:string){
    var: [list, mail];
    do: [
      list = url split ':';
      if(list head){
        "http":  "<a href=\"" + url + "\">" + url + "</a>";
        "https": "<a href=\"" + url + "\">" + url + "</a>";
        "ftp":   "<a href=\"" + url + "\">" + url + "</a>";
        "mailto": [
            mail = "";
            (list tail) each {
              arg: [str];
              do: [
                mail = mail + str;
              ];
            };
            "<a href=\"" + url + "\">" + mail + "</a>";
          ];
        other: [
            if((database get url length) == 0){
              true: url + "<a href=\"" + thisurl + "?cmd=edit&mypage=" + url + "\">" + editchar + "</a>";
              false: "<a href=\"" + thisurl + "?cmd=read&mypage=" + url + "\">" + url + "</a>";
            };
          ];
      };
    ];
  };

  fun convert_link(line){
    var: [f, g, start, end, prev, res];
    do: [
      loop {
        from: [
          start = 0;
          prev = 0;
          f = line find "[[";
          g = line find "]]";
          res = "";
        ];
        step: [
          start = end + 2;
          prev = start;
        ];
        do: [
          start = f start;
          if(start >= 0){
            false: [
              res = res + (line sub prev ((line length) - prev));
              exit;
            ];
            true: [
              end = g start;
              if(end >= 0){
                true: [
                  res = res + (line sub prev (start - prev))
                            + (make_link (line sub (start+2) (end - (start+2))));
                ];
              };
            ];
          };
        ];
      };
      res;
    ];
  };

  fun tag_convert(line){
    do: [
      if(line length > 0){
        true: [
          if(line nth 0){
            '*': [
               if((line length) > 2){
                 true: [
                   if(line nth 1){
                     '*': line = "<H3>" + (line sub 2 (line length - 2)) + "</H3>\n";
                     _:   line = "<H2>" + (line sub 1 (line length - 1)) + "</H2>\n";
                   };
                 ];
               };
            ];
            _: [
              if((line length) >= 4){
                true: [
                  if(line sub 0 4){
                    "----": line = "<HR>\n";
                    _: [
                      line = convert_link line;
                      line = line + "\n";
                    ];
                  };
                ];
                false: [
                  line = line + "\n";
                ];
              };
            ];
          };
        ];
        false: [ # null line
              line = "\n";
        ];
      };
      line;
    ];
  };

  fun print_content(){
    var: [temp];
    do: [
      temp = escape(database get (form "mypage"));

      reader = temp reader;
      temp = "";
      loop {
        until: reader eof?;
        do: [
          line = reader readline;
          line = tag_convert line;
          temp = temp + line;
        ];
      };

      print "<pre>" temp; println "</pre>";
    ];
  };

  fun escape(str:string){
    do: [
      str = str replace "&" "&amp;";
      str = str replace "<" "&lt;";
      str = str replace ">" "&gt;";
      str = str replace "\"" "&quot;";
      str;
    ];
  };

  fun print_footer(){
    do: [
      println "</body></html>";
    ];
  };

  fun print_header(title:string, canedit:bool){
    do: [
      println contenttype;
      println "";
      println "<html>";
      println ("<head><title>" + title + "</title>");
      println style;
      println "</head>";
      println ("<body bgcolor=\"" + bgcolor + "\">");
      println ("  <table width=\"100%\" bgcolor=\"" + titlecolor + "\" border=\"0\">");
      println ("    <tr valign=\"top\">");
      println ("      <td><b><tt>" + title + "</tt></b></td>");
      println "      <td align=\"right\"><tt>";
      println ("        <a href=\"" + thisurl + "?cmd=read&mypage=" + frontpage + "\">" + frontpage + "</a> | ");
      println ("        <a href=\"" + thisurl + "?cmd=new\">New</a> | ");
      if(canedit){
        true: [
            println ("        <a href=\"" + thisurl + "?cmd=edit&mypage=" + (form "mypage") + "\">" + naviedit + "</a> | ");
          ];
      };
      println ("        <a href=\"" + thisurl + "?cmd=index\">" + naviindex + "</a> | ");
      println ("        <a href=\"http://soopy.sourceforge.jp/wiki/\">Soopy Wiki</a>");
      println "      </tt></td>";
      println "    </tr>";
      println "  </table>";
    ];
  };

  fun print_error(msg:string){
    do: [
      print_header(errorpage, false);
      print ("<h1>" + msg + "</h1>");
      print_footer();
      quit();
    ];
  };

  fun do_write(){
    do: [
      if(form "mymsg" isNil?){
        true: [
            database delete (form "mypage");
            print_header((form "mypage") + msgdeleted, false);
          ];
        false: [
            database set((form "mypage"), (form "mymsg"));
            print_header(form "mypage", true);
            print_content();
          ];
      };
      print_footer();
    ];
  };

  fun do_index(){
    do: [
      print_header(indexpage, false);
      println "<ul>";
      database get_keys() sort each {
        arg: [key];
        do: [
          print "<li><a href=\"" thisurl "?cmd=read&mypage=" key "\"><tt>" key "</tt></a></li>";
          println "";
        ];
      };
      println "</ul>";
      print_footer();
    ];
  };

  fun do_edit(){
    var: [mymsg];
    do: [
      print_header(form "mypage", false);
      mymsg = escape(database get (form "mypage"));

      println ("<form action=\"" + thisurl + "\" method=\"POST\">");
      println ("  <input type=\"hidden\" name=\"cmd\" value=\"write\">");
      println ("  <input type=\"hidden\" name=\"mypage\" value=\"" + (form "mypage") + "\">");
      println ("  <input type=\"submit\" value=\"" + naviwrite + "\"><br>");
      println ("  <textarea cols=\"" + (cols toString)
               + "\" rows=\"" + (rows tostring)
               + "\" name=\"mymsg\" wrap=\"virtual\">" + mymsg
               + "</textarea><br>");
      println ("  <input type=\"submit\" value=\"" + naviwrite + "\">");
      println "</form>";

      println "<H1>ƥΥ롼</H1>";
      println "̾ϤʸΤޤϤޤ<br>";
      println "ϻѤǤޤ<br>";
      println "<br>";
      println "ޥʥ(----)Ƭ˽񤯤ȿʿˤʤޤ<br>";
      println "ꥹ(*)Ƭ˽񤯤縫Фˤʤޤ<br>";
      println "ꥹ(**)Ƭ˽񤯤ȾФˤʤޤ<br>";
      println "Ť[[]]Ǥäʸ񤯤ȡ󥯤ˤʤޤ<br>";
      println "<br>";

      print_footer();
    ];
  };

  fun do_read(){
    do: [
      print_header(form "mypage", true);
      print_content();
      print_footer();
    ];
  };

  fun do_new(){
    do: [
      print_header("Create New Page", false);
      println "<br><br>";
      println "ڡ̾ϤƤ";
      println ("<form action=\"" + thisurl + "\" method=\"POST\">");
      println ("  <input type=\"hidden\" name=\"cmd\" value=\"edit\">");
      println ("  <input type=\"text\" name=\"mypage\" size=\"20\">");
      println ("  <input type=\"submit\" value=\"" + naviwrite + "\"><br>");
      println "</form>";
      print_footer();
    ];
  };

  fun open_database(){
    do: [
      database = db;
      database open();
    ];
  };

  fun close_database(){
    do: [
      database close();
    ];
  };

  #
  # main program
  #
  fun main(){
    do: [
      init_form();

      #### database open ####
      open_database();

      if(form "cmd"){
        "read":   do_read();
        "write":  do_write();
        "edit":   do_edit();
        "index":  do_index();
        "new":    do_new();
        other: [
          form "mypage" = frontpage;
          do_read();
        ];
      };

      #### database close ####
      close_database();

    ];
    rescue: [
      print_header("Soopy Error", false);
      print_footer();
    ];
  };

} main();
