
program = {
  comment:  "file copy in soopy2";
  author:   "$Author: randy $";
  date:     "$Date: 2003/02/23 12:12:34 $";
  revision: "$Revision: 1.3 $";

  fun usage(){
    do: println "usage: soopy cp.sp src_file dist_file";
  };

  fun with_openIn_file(filename, body){
    comment: "open input-file & eval body & close file";
    var: [fin];
    do: [
      fin = openIn filename;
      body eval(fin);
      fin close;
    ];
    rescue: fin close;
  };

  fun with_openOut_file(filename, body){
    comment: "open output-file & eval body & close file";
    var: [fout];
    do: [
      fout = openOut filename;
      body eval(fout);
      fout close;
    ];
    rescue: fout close;
  };

  fun copy(src, dist){
    comment: "copy file from src to dist";
    do: with_openIn_file src {
          arg: [fin];
          var: [line];
          do: [
                with_openOut_file dist {
                  arg: [fout];
                  do: [
                    loop {
                      until: fin eof?;
                      do: [
                        line = fin readLine;
                        fout writeLine line;
                      ];
                    };
                  ];
                };
              ];
        };
  };

  /*
   * Main routine
   */
  fun main(){
    comment: "main routine";
    var: [files];
    do: [
      files = Soopy commandLine;
      if(files){
        [x,y]: copy(x,y);
        _:     usage();
      };
    ];
  };
};

program main();

