# Xg̓\L

fun even(xs){
  do: [
    [x | x <- xs, x % 2 == 0]
  ];
};

fun odd(xs){
  do: [
    [x | x <- xs, x % 2 == 1]
  ];
};

if(even []){
  []: [];  # do nothing
  else: println "error: even [] != nil";
};

if(odd []){
  []: [];  # do nothing
  else: println "error: odd [] != nil";
};

list = [1..10];

print "even: ";
println (even list);
print "odd:  ";
println (odd list);


#
# primes
#

fun primes(list){
  do: [
    if(list){
      x::xs : x :: (primes [n | n <- xs, n % x != 0]);
    };
  ];
};

print "primes: ";
println (primes [2..30]);

#
# quick sort
#

fun qsort(list){
  do: [
    if(list){
      []    : [];
      x::xs : (qsort [y | y<- xs, y <= x]
               @ (x :: (qsort [y | y <- xs, y > x])));
    };
  ];
};

list = [3, 7, 2, 8, 1, 6, 0, 4, 10, 9, 5];
print "qsort: " list " => ";
println (qsort list);


#
# quick sort 2
#

datatype Figure =
  Rect(x:int, y:int){
    fun area(){
      do: x * y;
    };
  }
| Circle(r:int){
    pi: 3.14;
    fun area(){
      do: r * r * pi;
    };
  }
;

fun qsort2(less, list){
  do: [
    if(list){
      []    : [];
      x::xs : (qsort2 less [y | y<- xs, less(y, x)]
               @ (x :: (qsort2 less [y | y <- xs, !less(y, x)])));
    };
  ];
};

fun less(x, y){
  do: [
    (x area()) < (y area())
  ];
};

fig_list = [Rect(5,7), Circle(8), Rect(2,4), Circle(3), Rect(4,7), Rect(10, 5)];

print "qsort2: "; println fig_list;
print "    ==> "; println (qsort2 less fig_list);

/*
fig_list each {
  comment: "fig_list̐}`̖ʐςԂɋ߂ĕ\B";
  arg: [val];
  do: [
    print val " => ";
    println(val area());
  ];
};
*/

#
# diagonalising ZF
#

fun cmp(t, t2){
  do: [
    if(t){
      (x1, y1, z1): [
        if(t2){
          (x2, y2, z2): [
            if(x1 < x2){
              true: true;
              false: if(y1 < y2){
                       true: true;
                       false: z1 < z2;
                     };
            }
          ];
        };
      ];
    };
  ];
};

fun eq(t, t2){
  do: [
    if(t){
      (x1, y1, z1): [
        if(t2){
          (x2, y2, z2): [
            if(x1 == x2){
              true: true;
              false: if(y1 == y2){
                       true: true;
                       false: z1 == z2;
                     };
            }
          ];
        };
      ];
    };
  ];
};

l2 = [(x,y,z) |  x <- [0..4], y <- [0..4], z <- [0..4]];
l3 = [(x,y,z) // x <- [0..4], y <- [0..4], z <- [0..4]];
l4 = qsort2 cmp l3;

print "<<l2>>: "; println l2 "";
print "<<l3>>: "; println l3 "";
print "<<l4>>: "; println l4 "";

#
# compare l2 l3
#
bool = true;
loop {
  from: i = 0;
  step: i = i + 1;
  while: i < (l2 length);
  do:
    if(eq(l2 nth i, l3 nth i)){
      false: [
        bool = false;
        break;
      ];
    };
};

if(bool){
  true:  println "all equal. l2 & l3";
  false: println "not equal. l2 & l3ij";  # 
};

#
# compare l2 l4
#
bool = true;
loop {
  from: i = 0;
  step: i = i + 1;
  while: i < (l2 length);
  do:
    if(eq(l2 nth i, l4 nth i)){
      false: [
        bool = false;
        break;
      ];
    };
};

if(bool){
  true:  println "all equal. l2 & l4ij";  # 
  false: println "not equal. l2 & l4";
};

println "" "";

#
#
fun cartesian_product(x, y){
  do: [
    [(a,b) // a <- x, b <- y]
  ];
};

print "cartesian_product: "; println(cartesian_product([1..4], [5..7]));


#
#

println "" "Xg̃eXg";
l5 = [(x,y,z) // x <- [0..], y <- [0..], z <- [0..]];
loop {
  from: [i = 0, l6 = l5];
  step: [i = i + 1, l6 = l6 tail];
  while: i < 100;
  do: print (l6 head) ", ";
};

println "" "T̃eXg";
println [(a,b,c,d,e) // a <- [0..3], b <- [0..3], c <- [0..3], d <- [0..3], e <- [0..3]];

