
program = {
  comment:  "cat program in soopy2";
  author:   "$Author: randy $";
  date:     "$Date: 2004/03/27 05:59:44 $";
  revision: "$Revision: 1.3 $";

  fun usage(){
    do: [
      println "usage: soopy cat.sp file1 [file2 ... fileN]";
    ];
  };

  fun printlines(lines){
    comment: "print each lines with newline";
    do: match(lines){
          []: true;
          x::xs: [
              println x;
              printlines xs;
            ];
        };
  };

  fun with_openEncodeIn_file(encoder, filename, body){
    comment: "open file & eval body & close file";
    var: [fin, f];
    do: [
      f = openIn filename;
      fin = encoder decoderIn(f);
      body eval(fin);
      fin close;
    ];
    rescue: fin close;
  };


  fun cat(file){
    comment: "cat a file";
    do: [
      with_openEncodeIn_file SJIS file {
        arg: [fin];
        var: [lines];
        do: [
          lines = fin readlines;
          printlines lines;
        ];
      };
    ];
  };

  fun cats(files){
    comment: "cat files";
    do: match(files){
          []:    [];
          x::xs: [ cat x; cats xs; ];
        };
  };

  /*
   * Main routine
   */
  fun main(){
    comment: "main routine";
    var: [files];
    do: [
      files = Soopy commandLine;
      match(files){
        []: usage();
        _:  cats(files);
      };
    ];
  };
};

/*
 * run program
 */
program main();

