/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataTable {
    private Map<String, List<Object>> map = new ConcurrentHashMap<String, List<Object>>();
    private int lastIndex = 0;
    private List<String> columns;
    private String name;

    public DataTable(String name, List<String> columns) {
        for (String column : columns) {
            List row = Collections.synchronizedList(new LinkedList());
            this.map.put(column, row);
        }
        this.columns = columns;
        this.name = name;
    }

    public List<String> getHeader() {
        return this.columns;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getRow(int rowNumber) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.map.keySet()) {
            List<Object> obj = this.map.get(key);
            if (obj.size() <= rowNumber) continue;
            Object item = obj.get(rowNumber);
            result.put(key, item);
        }
        return result;
    }

    public List<Map<String, Object>> getRows(int startIndex, int endIndex) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        int i = startIndex;
        while (i <= endIndex) {
            HashMap<String, Object> aRow = new HashMap<String, Object>();
            for (String key : this.map.keySet()) {
                List<Object> obj = this.map.get(key);
                if (obj.size() <= i) continue;
                Object item = obj.get(i);
                aRow.put(key, item);
            }
            result.add(aRow);
            ++i;
        }
        return result;
    }

    public List<Map<String, Object>> getRows() {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        int i = 0;
        while (i <= this.lastIndex) {
            HashMap<String, Object> aRow = new HashMap<String, Object>();
            for (String key : this.map.keySet()) {
                List<Object> obj = this.map.get(key);
                if (obj.size() <= i) continue;
                Object item = obj.get(i);
                aRow.put(key, item);
            }
            result.add(aRow);
            ++i;
        }
        return result;
    }

    public DataTable innerJoin(DataTable table) {
        List<String> newColumns = Collections.synchronizedList(new LinkedList());
        Collections.copy(newColumns, this.getHeader());
        List<String> targetColumns = table.getHeader();
        newColumns.addAll(targetColumns);
        return null;
    }

    public DataTable outerJoin(DataTable table) {
        return null;
    }

    public int size() {
        return this.lastIndex;
    }
}

