/*
 * Decompiled with CFR 0.152.
 */
package sos.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import sos.gui.JCanvasColor;
import sos.process.ImageInfo;
import sos.util.ColorVector;

public class JColorPanel
extends JPanel {
    private ArrayList<JCanvasColor> canvasList = new ArrayList();
    private boolean choosable = false;
    private String[] title;
    private String contTitle;

    public JColorPanel() {
        this.initComponents();
    }

    public final void init(boolean choosable, String[] arg) {
        this.title = arg;
        this.contTitle = null;
        this.choosable = choosable;
        this.setColorNumber(arg.length);
    }

    public final void init(boolean choosable, int number, String arg) {
        this.contTitle = arg;
        this.choosable = choosable;
        this.setColorNumber(number);
    }

    public final int getColorNumber() {
        return this.canvasList.size();
    }

    public final void setColorNumber(int newNumber) {
        int oldNumber = this.canvasList.size();
        if (oldNumber == newNumber) {
            return;
        }
        if (oldNumber < newNumber) {
            for (int i = oldNumber; i < newNumber; ++i) {
                this.addColor();
            }
        } else {
            for (int i = newNumber; i < oldNumber; ++i) {
                this.removeColor(newNumber);
            }
        }
    }

    public final void addColor() {
        if (this.contTitle != null) {
            this.title = new String[this.canvasList.size() + 1];
            for (int i = 0; i < this.title.length; ++i) {
                this.title[i] = this.contTitle + (i + 1);
            }
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        JLabel label = new JLabel(this.title[this.canvasList.size()] + ": ");
        label.setForeground(new Color(102, 102, 102));
        this.add((Component)label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        JCanvasColor tempCanvas = new JCanvasColor();
        tempCanvas.setName(this.title[this.canvasList.size()]);
        tempCanvas.setColorChoosable(this.choosable);
        this.add((Component)tempCanvas, gridBagConstraints);
        this.canvasList.add(tempCanvas);
    }

    public final void removeColor() {
        this.removeColor(this.canvasList.size() - 1);
    }

    public final void removeColor(int index) {
        this.remove(index * 2);
        this.remove(index * 2);
        this.canvasList.remove(index);
    }

    public final void clearColor() {
        for (int i = 0; i < this.canvasList.size(); ++i) {
            this.canvasList.get(i).setColor(Color.black);
        }
    }

    public final void updateColor(int index, Color color) {
        this.canvasList.get(index).setColor(color);
    }

    public final void updateColor(int index, int[] data) {
        this.canvasList.get(index).setColor(data);
    }

    public final void updateColor(int[][] data) {
        int n = Math.min(data.length, this.canvasList.size());
        for (int i = 0; i < n; ++i) {
            this.canvasList.get(i).setColor(data[i]);
        }
    }

    public final void setRandomColor(ImageInfo imi) {
        for (int un = 0; un < this.canvasList.size(); ++un) {
            int index = (int)(Math.random() * (double)imi.getUsedColorNumber());
            int currentRGBint = imi.getIntRGB(index);
            this.updateColor(un, ColorVector.intToRGB(currentRGBint));
        }
    }

    public final Color getColor(int index) {
        return this.canvasList.get(index).getColor();
    }

    public final int getColorInt(int index) {
        return this.canvasList.get(index).getColorInt();
    }

    public final int[] getColorInt() {
        int[] array = new int[this.canvasList.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getColorInt(i);
        }
        return array;
    }

    public final int[] getColorArray(int index) {
        return this.canvasList.get(index).getColorArray();
    }

    public final int[][] getColorArray() {
        int[][] array = new int[this.canvasList.size()][];
        for (int i = 0; i < this.canvasList.size(); ++i) {
            array[i] = this.getColorArray(i);
        }
        return array;
    }

    public final String getColorString(String separator) {
        int[] RGB = this.canvasList.get(0).getColorArray();
        String result = RGB[0] + "," + RGB[1] + "," + RGB[2];
        for (int i = 1; i < this.canvasList.size(); ++i) {
            RGB = this.canvasList.get(i).getColorArray();
            result = result + separator + RGB[0] + "," + RGB[1] + "," + RGB[2];
        }
        return result;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }
}

