/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import sos.util.FirstInFirstOut;
import sos.util.Sort;

public final class SortDouble
extends Sort {
    private double[] input;
    private double min;
    private double max;

    public SortDouble(double[] input) {
        this.input = input;
        this.initAscendingOrder(input.length);
        this.setRange(0, input.length);
        this.sort();
    }

    public SortDouble(double[] input, int start, int end) {
        this.input = input;
        this.initAscendingOrder(input.length);
        this.setRange(start, end);
        this.sort();
    }

    public void sortAdditional(int start, int end) {
        this.setRange(start, end);
        this.sort();
    }

    protected void sort() {
        int k;
        int j;
        int i;
        this.heap = new int[this.range];
        int num = 0;
        for (i = 0; i < this.range; ++i) {
            this.heap[num++] = i + this.offset;
            j = num;
            k = j / 2;
            while (1 < j && this.input[this.heap[j - 1]] < this.input[this.heap[k - 1]]) {
                this.swap(j - 1, k - 1);
                j = k;
                k = j / 2;
            }
        }
        i = 0;
        while (0 < num) {
            this.ascendingOrder[i + this.offset] = this.heap[0];
            this.heap[0] = this.heap[--num];
            j = 1;
            k = j * 2;
            while (k <= num) {
                if (k + 1 <= num && this.input[this.heap[k]] < this.input[this.heap[k - 1]]) {
                    ++k;
                }
                if (this.input[this.heap[k - 1]] < this.input[this.heap[j - 1]]) {
                    this.swap(j - 1, k - 1);
                }
                j = k;
                k = j * 2;
            }
            ++i;
        }
        this.heap = null;
    }

    public int[] getTieRank() {
        int[] tieRank = new int[this.input.length];
        tieRank[0] = 0;
        for (int i = 1; i < tieRank.length; ++i) {
            int ranking = this.input[this.ascendingOrder[i]] == this.input[this.ascendingOrder[i - 1]] ? tieRank[this.ascendingOrder[i - 1]] : i;
            tieRank[this.ascendingOrder[i]] = ranking;
        }
        return tieRank;
    }

    public int[] getDistributive() {
        FirstInFirstOut fifo = new FirstInFirstOut(this.ascendingOrder.length + 1);
        fifo.add(0);
        for (int i = 1; i < this.ascendingOrder.length; ++i) {
            if (this.input[this.ascendingOrder[i]] == this.input[this.ascendingOrder[i - 1]]) continue;
            fifo.add(i);
        }
        fifo.add(this.ascendingOrder.length);
        return fifo.toArray();
    }

    public void findMax() {
        if (this.maxIndex > -1) {
            return;
        }
        this.maxIndex = 0;
        this.max = this.input[0];
        for (int i = 1; i < this.input.length; ++i) {
            if (!(this.input[i] > this.max)) continue;
            this.max = this.input[i];
            this.maxIndex = i;
        }
    }

    public void findMin() {
        if (this.minIndex > -1) {
            return;
        }
        this.minIndex = 0;
        this.min = this.input[0];
        for (int i = 1; i < this.input.length; ++i) {
            if (!(this.input[i] < this.min)) continue;
            this.min = this.input[i];
            this.minIndex = i;
        }
    }
}

