/*
 * Decompiled with CFR 0.152.
 */
package gunmetry;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class JColorView
extends JPanel {
    private HashSet<JComponent> listeners = new HashSet();
    private boolean colorChoosable;
    private int[] RGB = new int[3];
    private JColorChooser jColorChooser;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelColorPreview;
    private JLabel jLabelColorStr;

    public JColorView() {
        this.initComponents();
        this.colorChoosable = true;
    }

    public void addColorChangeListener(JComponent comp) {
        this.listeners.add(comp);
    }

    public void setColor(Color color) {
        this.RGB[0] = color.getRed();
        this.RGB[1] = color.getGreen();
        this.RGB[2] = color.getBlue();
        String str = "(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        this.jLabelColorStr.setText(str);
        this.jLabelColorPreview.setBackground(color);
        for (JComponent comp : this.listeners) {
            comp.setForeground(color);
        }
    }

    public void setColor(int[] color) {
        this.setColor(new Color(color[0], color[1], color[2]));
    }

    public Color getColor() {
        return this.jLabelColorPreview.getBackground();
    }

    public int getColorInt() {
        return this.getColor().getRGB();
    }

    public int[] getColorArray() {
        return this.RGB;
    }

    public void setColorChoosable(boolean value) {
        this.colorChoosable = value;
    }

    private void initComponents() {
        this.jColorChooser = new JColorChooser();
        this.jLabel1 = new JLabel();
        this.jLabelColorPreview = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabelColorStr = new JLabel();
        this.setLayout(new BoxLayout(this, 0));
        this.jLabel1.setText(" ");
        this.add(this.jLabel1);
        this.jLabelColorPreview.setBorder(new EtchedBorder());
        this.jLabelColorPreview.setMaximumSize(new Dimension(15, 15));
        this.jLabelColorPreview.setMinimumSize(new Dimension(15, 15));
        this.jLabelColorPreview.setOpaque(true);
        this.jLabelColorPreview.setPreferredSize(new Dimension(15, 15));
        this.jLabelColorPreview.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JColorView.this.jLabelColorPreviewMousePressed(evt);
            }
        });
        this.add(this.jLabelColorPreview);
        this.jLabel2.setText(" ");
        this.add(this.jLabel2);
        this.jLabelColorStr.setText("( , , )");
        this.add(this.jLabelColorStr);
    }

    private void jLabelColorPreviewMousePressed(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Choose color...", this.getColor());
        this.setColor(newColor);
    }
}

