/*
 * Decompiled with CFR 0.152.
 */
package orch;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import javax.imageio.ImageIO;
import sos.graphics.SOSGraphics;
import sos.io.SOSImageIO;
import sos.util.ColorVector;

public class ImagePiece
implements SOSGraphics {
    private File fileOfImage;
    private boolean hasImage;
    private boolean fixed = false;
    private int tableIndex;
    private Point tableLocation = new Point();
    private Rectangle bounds;
    private int[] pixelsData;
    private int[][] rgb;
    private Image thumbnail;
    private Dimension thumbnailSize = new Dimension();

    public ImagePiece(int width, int height, File file) {
        this.fileOfImage = file;
        this.thumbnailSize.width = width;
        this.thumbnailSize.height = height;
        this.makeThumbnail();
    }

    public String getPath() {
        if (this.fileOfImage == null) {
            return null;
        }
        return this.fileOfImage.getPath();
    }

    private int[] getPixels(Image img) {
        int[] pixels = new int[this.bounds.width * this.bounds.height];
        PixelGrabber grabber = new PixelGrabber(img, 0, 0, this.bounds.width, this.bounds.height, pixels, 0, this.bounds.width);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pixels;
    }

    private void makeThumbnail() {
        Dimension size = SOSImageIO.getImageSize(this.fileOfImage);
        this.bounds = new Rectangle(0, 0, size.width, size.height);
        int stepX = (int)Math.ceil(1.0 * (double)this.bounds.width / (double)this.thumbnailSize.width);
        int stepY = (int)Math.ceil(1.0 * (double)this.bounds.height / (double)this.thumbnailSize.height);
        int step = Math.max(stepX, stepY);
        this.thumbnail = null;
        this.thumbnail = step <= 1 ? SOSImageIO.readImage(this.fileOfImage) : SOSImageIO.getSubsampledImage(this.fileOfImage, step, step);
        this.hasImage = this.thumbnail != null;
    }

    public Image getThumbnail() {
        if (this.thumbnail == null) {
            this.makeThumbnail();
        }
        return this.thumbnail;
    }

    public void clearThumbnail() {
        this.thumbnail = null;
    }

    public boolean hasImage() {
        return this.hasImage;
    }

    public BufferedImage getImage() {
        BufferedImage img = null;
        try {
            img = ImageIO.read(this.fileOfImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Dimension getSize() {
        return this.bounds.getSize();
    }

    public int[] getPixelsData() {
        if (this.pixelsData == null) {
            BufferedImage img = this.getImage();
            this.pixelsData = ColorVector.intRGBtoL(this.getPixels(img));
        }
        return this.pixelsData;
    }

    public int[] getPixelsData(int step) {
        if (this.pixelsData == null) {
            BufferedImage img = SOSImageIO.readImage(this.fileOfImage);
            Image subsampledImg = img.getScaledInstance(this.bounds.width / step, this.bounds.height / step, 16);
            Image expandImg = subsampledImg.getScaledInstance(this.bounds.width, this.bounds.height, 2);
            this.pixelsData = ColorVector.intRGBtoL(this.getPixels(expandImg));
        }
        return this.pixelsData;
    }

    public int[][] getRGB(int step) {
        if (this.rgb == null) {
            BufferedImage img = SOSImageIO.readImage(this.fileOfImage);
            Image subsampledImg = img.getScaledInstance(this.bounds.width / step, this.bounds.height / step, 16);
            Image expandImg = subsampledImg.getScaledInstance(this.bounds.width, this.bounds.height, 2);
            this.rgb = new int[this.bounds.width * this.bounds.height][3];
            ColorVector.getRGB(this.getPixels(expandImg), this.rgb);
        }
        return this.rgb;
    }

    public void clearRGB() {
        this.rgb = null;
    }

    public void clearPixelsData() {
        this.pixelsData = null;
    }

    public int getThumbnailOriginalRatio() {
        return this.bounds.width / this.thumbnailSize.width;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public int getIndex() {
        return this.tableIndex;
    }

    public void setIndex(int index) {
        this.tableIndex = index;
    }

    public Point getTableLocation() {
        return this.tableLocation;
    }

    public void setTableLocation(int x, int y) {
        this.tableLocation.setLocation(x, y);
    }

    public void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.yellow);
        g2d.draw(this.bounds);
    }
}

