/*
 * Decompiled with CFR 0.152.
 */
package orch;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import orch.ImagePiece;
import orch.JDropableTable;

public class ImageTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private Color lightBlue = new Color(240, 240, 255);
    private Color blue = new Color(180, 180, 255);
    private Color lightGray = new Color(235, 235, 235);

    public ImageTableCellRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean canvasRow = row % 2 != 0;
        boolean canvasColumn = column % 2 != 0;
        this.setIcon(null);
        if (!canvasRow && !canvasColumn) {
            this.setBackground(Color.black);
        } else {
            JDropableTable dropTable = (JDropableTable)jTable;
            if (canvasRow && canvasColumn) {
                if (isSelected && dropTable.isDragging()) {
                    this.setBackground(this.lightGray);
                } else {
                    this.setBackground(Color.white);
                }
                if (obj != null) {
                    ImagePiece imagePiece = (ImagePiece)obj;
                    this.setIcon(new ImageIcon(imagePiece.getThumbnail()));
                }
            } else if (isSelected && dropTable.isDragging()) {
                this.setBackground(this.blue);
            } else {
                this.setBackground(this.lightBlue);
            }
        }
        return this;
    }
}

