/*
 * Decompiled with CFR 0.152.
 */
package orch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import orch.ImagePiece;
import orch.ImageTableCellRenderer;
import orch.JDropableTable;
import orch.Matching;
import orch.plugin.CoarseFineMatching;
import sos.canvas.JObjectCanvas;
import sos.graphics.SOSRectangle;
import sos.io.SOSImageIO;
import sos.window.JProgressDialog;

public class OrchViewer
extends JFrame {
    private ImagePiece[][] tnArray;
    private Rectangle rectThumbnailExist = null;
    private LinkedList<Point> thumbnails = new LinkedList();
    private Matching imageMatching;
    private Timer timer;
    private TimerTask taskLoadImage;
    private TimerTask taskAnalyze;
    private SOSImageIO imageIO = new SOSImageIO();
    private SOSRectangle rectImage = new SOSRectangle();
    private SOSRectangle rectVerticalOverlap = new SOSRectangle();
    private SOSRectangle rectHorizontalOverlap = new SOSRectangle();
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JObjectCanvas jCanvasOverlap;
    private JDialog jDialogOption;
    private JDialog jDialogSetTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JMenu jMenuAnalyze;
    private JMenuItem jMenuAnalyzeStart;
    private JMenuBar jMenuBarMain;
    private JMenuItem jMenuClearTable;
    private JMenuItem jMenuDeleteImage;
    private JMenu jMenuFile;
    private JMenuItem jMenuOpenTable;
    private JMenuItem jMenuOption;
    private JMenuItem jMenuRemoveColumn;
    private JMenuItem jMenuRemoveRow;
    private JMenuItem jMenuSaveTable;
    private JMenuItem jMenuSetTable;
    private JMenu jMenuTable;
    private JPanel jPanel1;
    private JPopupMenu jPopupRemove;
    private JScrollPane jScrollTableImages;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerColumnNumber;
    private JSpinner jSpinnerHorizontal;
    private JSpinner jSpinnerMinimum;
    private JSpinner jSpinnerRowNumber;
    private JSpinner jSpinnerVertical;
    private JDropableTable jTableImages;

    public OrchViewer() {
        this.initComponents();
        this.jTableImages.setDefaultRenderer(Object.class, new ImageTableCellRenderer());
        this.jTableImages.applyCellSize();
        this.jTableImages.setSelectionMode(0);
        this.jTableImages.setComponentPopupMenu(this.jPopupRemove);
        this.jScrollTableImages.setColumnHeader(null);
        SpinnerNumberModel nColumnModel = new SpinnerNumberModel(3, 1, 100, 1);
        this.jSpinnerColumnNumber.setModel(nColumnModel);
        SpinnerNumberModel nRowModel = new SpinnerNumberModel(3, 1, 100, 1);
        this.jSpinnerRowNumber.setModel(nRowModel);
        this.jDialogSetTable.setLocation(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
        this.jDialogSetTable.pack();
        SpinnerNumberModel horizontalModel = new SpinnerNumberModel(0.3, 0.1, 1.0, 0.1);
        this.jSpinnerHorizontal.setModel(horizontalModel);
        SpinnerNumberModel verticalModel = new SpinnerNumberModel(0.8, 0.1, 1.0, 0.1);
        this.jSpinnerVertical.setModel(verticalModel);
        SpinnerNumberModel minimumModel = new SpinnerNumberModel(0.01, 0.01, 0.3, 0.01);
        this.jSpinnerMinimum.setModel(minimumModel);
        this.jDialogOption.pack();
        this.timer = new Timer();
        this.rectImage.setBounds(160, 120, 160, 120);
        this.rectImage.setColor(Color.yellow);
        this.jCanvasOverlap.addGraphicObject(this.rectImage);
        this.rectHorizontalOverlap.setColor(new Color(0, 0, 255, 32));
        this.jCanvasOverlap.addGraphicObject(this.rectHorizontalOverlap);
        this.rectVerticalOverlap.setColor(new Color(0, 0, 255, 32));
        this.jCanvasOverlap.addGraphicObject(this.rectVerticalOverlap);
    }

    private void createLoadImageTask() {
        final OrchViewer frame = this;
        this.taskLoadImage = new TimerTask(){

            public void run() {
                ArrayList<String> args = OrchViewer.this.imageIO.readStrings();
                final Point size = OrchViewer.this.stringToPoint(args.get(0));
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            OrchViewer.this.jTableImages.setTable(size.x * 2 + 1, size.y * 2 + 1);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JProgressDialog progress = new JProgressDialog(frame);
                progress.setLocation(frame.getX() + frame.getWidth() / 2, frame.getY() + frame.getHeight() / 2);
                progress.start("Loading...", false);
                int progressRatio = 0;
                for (int i = 1; i < args.size(); i += 2) {
                    Point p = OrchViewer.this.stringToPoint(args.get(i));
                    String path = args.get(i + 1);
                    ImagePiece tn = new ImagePiece(160, 120, new File(path));
                    OrchViewer.this.jTableImages.setValueAt(tn, p.y * 2 + 1, p.x * 2 + 1);
                    progressRatio = 100 * i / (args.size() - 1);
                    progress.setValue(progressRatio);
                }
                progress.stop();
            }
        };
    }

    private void createAnalyzeTask() {
        this.taskAnalyze = new TimerTask(){

            public void run() {
                if (!OrchViewer.this.pickupThumbnailFromTable()) {
                    return;
                }
                OrchViewer.this.setVisible(false);
                OrchViewer.this.uniteAllImages();
                OrchViewer.this.saveResult();
                OrchViewer.this.setVisible(true);
            }
        };
    }

    private boolean pickupThumbnailFromTable() {
        TableModel model = this.jTableImages.getModel();
        this.rectThumbnailExist = null;
        this.thumbnails = new LinkedList();
        int nImageRow = model.getRowCount() / 2;
        int nImageHeight = model.getColumnCount() / 2;
        for (int y = 0; y < nImageRow; ++y) {
            for (int x = 0; x < nImageHeight; ++x) {
                ImagePiece tn = (ImagePiece)model.getValueAt(y * 2 + 1, x * 2 + 1);
                if (tn == null || !tn.hasImage()) continue;
                if (this.rectThumbnailExist == null) {
                    this.rectThumbnailExist = new Rectangle(x, y, 0, 0);
                } else {
                    this.rectThumbnailExist.add(x, y);
                }
                this.thumbnails.add(new Point(x, y));
            }
        }
        if (this.rectThumbnailExist == null) {
            return false;
        }
        ++this.rectThumbnailExist.width;
        ++this.rectThumbnailExist.height;
        return true;
    }

    private void uniteAllImages() {
        TableModel model = this.jTableImages.getModel();
        this.tnArray = new ImagePiece[this.rectThumbnailExist.height][this.rectThumbnailExist.width];
        while (!this.thumbnails.isEmpty()) {
            Point p = this.thumbnails.removeFirst();
            int newX = p.x - this.rectThumbnailExist.x;
            int newY = p.y - this.rectThumbnailExist.y;
            this.tnArray[newY][newX] = (ImagePiece)model.getValueAt(p.y * 2 + 1, p.x * 2 + 1);
            this.tnArray[newY][newX].setFixed(false);
        }
        double verticalOverlapRatio = (Double)this.jSpinnerVertical.getValue();
        double horizontalOverlapRatio = (Double)this.jSpinnerHorizontal.getValue();
        double minOverlapRatio = (Double)this.jSpinnerMinimum.getValue();
        this.imageMatching = new CoarseFineMatching();
        this.imageMatching.init(this.tnArray);
        this.imageMatching.start(horizontalOverlapRatio, verticalOverlapRatio, minOverlapRatio);
    }

    private void saveResult() {
        File file = this.imageIO.getSaveFile();
        if (file == null) {
            return;
        }
        int type = this.imageIO.getFileType();
        this.imageMatching.setVisible(false);
        JProgressDialog progress = new JProgressDialog(this);
        progress.setLocation(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
        progress.start("Saving the result image...", true);
        Rectangle uniteRect = new Rectangle();
        for (int y = 0; y < this.tnArray.length; ++y) {
            for (int x = 0; x < this.tnArray[y].length; ++x) {
                if (this.tnArray[y][x] == null) continue;
                uniteRect.add(this.tnArray[y][x].getBounds());
                this.tnArray[y][x].clearPixelsData();
                this.tnArray[y][x].clearThumbnail();
            }
        }
        BufferedImage img = new BufferedImage(uniteRect.width, uniteRect.height, 1);
        Graphics g = img.getGraphics();
        for (int y = 0; y < this.tnArray.length; ++y) {
            for (int x = 0; x < this.tnArray[y].length; ++x) {
                if (this.tnArray[y][x] == null) continue;
                Rectangle rect = this.tnArray[y][x].getBounds();
                g.drawImage(this.tnArray[y][x].getImage(), rect.x - uniteRect.x, rect.y - uniteRect.y, null);
            }
        }
        SOSImageIO.writeImage(file, type, img);
        progress.stop();
    }

    private Point stringToPoint(String arg) {
        String[] location = arg.split(",");
        return new Point(Integer.parseInt(location[0]), Integer.parseInt(location[1]));
    }

    private void drawOverlap() {
        double verticalOverlapRatio = (Double)this.jSpinnerVertical.getValue();
        double horizontalOverlapRatio = (Double)this.jSpinnerHorizontal.getValue();
        double minOverlapRatio = (Double)this.jSpinnerMinimum.getValue();
        Dimension size = new Dimension();
        size.width = (int)((double)this.rectImage.width * horizontalOverlapRatio);
        size.height = (int)((double)this.rectImage.height * verticalOverlapRatio);
        Dimension minSize = new Dimension();
        minSize.width = (int)((double)this.rectImage.width * minOverlapRatio);
        minSize.height = (int)((double)this.rectImage.height * minOverlapRatio);
        this.rectHorizontalOverlap.setLocation(this.rectImage.x + this.rectImage.width - size.width, this.rectImage.y - size.height);
        this.rectHorizontalOverlap.width = 160 + size.width - minSize.width;
        this.rectHorizontalOverlap.height = 120 + size.height * 2;
        this.rectVerticalOverlap.setLocation(this.rectImage.x - size.width, this.rectImage.y + this.rectImage.height - size.height);
        this.rectVerticalOverlap.width = 160 + size.width * 2;
        this.rectVerticalOverlap.height = 120 + size.height - minSize.height;
        this.jCanvasOverlap.repaint();
    }

    public void checkMaxOfMinOverlap() {
        double min = Math.min((Double)this.jSpinnerHorizontal.getValue(), (Double)this.jSpinnerVertical.getValue());
        SpinnerNumberModel model = (SpinnerNumberModel)this.jSpinnerMinimum.getModel();
        model.setMaximum(Double.valueOf(min));
        if (min < (Double)this.jSpinnerMinimum.getValue()) {
            model.setValue(min);
        }
    }

    private void initComponents() {
        this.jPopupRemove = new JPopupMenu();
        this.jMenuDeleteImage = new JMenuItem();
        this.jMenuRemoveColumn = new JMenuItem();
        this.jMenuRemoveRow = new JMenuItem();
        this.jDialogSetTable = new JDialog();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSpinnerColumnNumber = new JSpinner();
        this.jSpinnerRowNumber = new JSpinner();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jDialogOption = new JDialog();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSpinnerHorizontal = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jSpinnerVertical = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jSpinnerMinimum = new JSpinner();
        this.jCanvasOverlap = new JObjectCanvas();
        this.jScrollTableImages = new JScrollPane();
        this.jTableImages = new JDropableTable();
        this.jMenuBarMain = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuOpenTable = new JMenuItem();
        this.jMenuSaveTable = new JMenuItem();
        this.jMenuTable = new JMenu();
        this.jMenuSetTable = new JMenuItem();
        this.jMenuClearTable = new JMenuItem();
        this.jMenuAnalyze = new JMenu();
        this.jMenuAnalyzeStart = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuOption = new JMenuItem();
        this.jMenuDeleteImage.setText("Delete Image");
        this.jMenuDeleteImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jMenuDeleteImageActionPerformed(evt);
            }
        });
        this.jPopupRemove.add(this.jMenuDeleteImage);
        this.jMenuRemoveColumn.setText("Remove column");
        this.jMenuRemoveColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jMenuRemoveColumnActionPerformed(evt);
            }
        });
        this.jPopupRemove.add(this.jMenuRemoveColumn);
        this.jMenuRemoveRow.setText("Remove row");
        this.jMenuRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jMenuRemoveRowActionPerformed(evt);
            }
        });
        this.jPopupRemove.add(this.jMenuRemoveRow);
        this.jDialogSetTable.getContentPane().setLayout(new GridBagLayout());
        this.jDialogSetTable.setAlwaysOnTop(true);
        this.jDialogSetTable.setModal(true);
        this.jDialogSetTable.setResizable(false);
        this.jLabel1.setText("column (x): ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jDialogSetTable.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("row (y): ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jDialogSetTable.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jSpinnerColumnNumber.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jDialogSetTable.getContentPane().add((Component)this.jSpinnerColumnNumber, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jDialogSetTable.getContentPane().add((Component)this.jSpinnerRowNumber, gridBagConstraints);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.jDialogSetTable.getContentPane().add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setText("CANCEL");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.jDialogSetTable.getContentPane().add((Component)this.jButtonCancel, gridBagConstraints);
        this.jDialogOption.setTitle("Overlap Setting");
        this.jLabel3.setText("Horizontal:");
        this.jPanel1.add(this.jLabel3);
        this.jSpinnerHorizontal.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                OrchViewer.this.jSpinnerHorizontalStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jSpinnerHorizontal);
        this.jLabel4.setText(" Vertical:");
        this.jPanel1.add(this.jLabel4);
        this.jSpinnerVertical.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                OrchViewer.this.jSpinnerVerticalStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jSpinnerVertical);
        this.jLabel5.setText(" Minimum:");
        this.jPanel1.add(this.jLabel5);
        this.jSpinnerMinimum.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                OrchViewer.this.jSpinnerMinimumStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jSpinnerMinimum);
        this.jDialogOption.getContentPane().add((Component)this.jPanel1, "South");
        this.jCanvasOverlap.setPreferredSize(new Dimension(480, 360));
        this.jDialogOption.getContentPane().add((Component)this.jCanvasOverlap, "Center");
        this.setDefaultCloseOperation(3);
        this.setTitle("Orch 1.0");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OrchViewer.this.formWindowClosing(evt);
            }
        });
        this.jScrollTableImages.setPreferredSize(new Dimension(518, 398));
        this.jTableImages.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5", "Title 6", "Title 7"}));
        this.jTableImages.setAutoResizeMode(0);
        this.jTableImages.setCellSelectionEnabled(true);
        this.jTableImages.setDragEnabled(true);
        this.jScrollTableImages.setViewportView(this.jTableImages);
        this.getContentPane().add((Component)this.jScrollTableImages, "Center");
        this.jMenuFile.setText("File");
        this.jMenuOpenTable.setText("Open Table file");
        this.jMenuOpenTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jMenuOpenTableActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuOpenTable);
        this.jMenuSaveTable.setText("Save Table file");
        this.jMenuSaveTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jMenuSaveTableActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveTable);
        this.jMenuBarMain.add(this.jMenuFile);
        this.jMenuTable.setText("Table");
        this.jMenuSetTable.setText("Set Table");
        this.jMenuSetTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jMenuSetTableActionPerformed(evt);
            }
        });
        this.jMenuTable.add(this.jMenuSetTable);
        this.jMenuClearTable.setText("Clear Table");
        this.jMenuClearTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jMenuClearTableActionPerformed(evt);
            }
        });
        this.jMenuTable.add(this.jMenuClearTable);
        this.jMenuBarMain.add(this.jMenuTable);
        this.jMenuAnalyze.setText("Analyze");
        this.jMenuAnalyzeStart.setText("Start");
        this.jMenuAnalyzeStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jMenuAnalyzeStartActionPerformed(evt);
            }
        });
        this.jMenuAnalyze.add(this.jMenuAnalyzeStart);
        this.jMenuAnalyze.add(this.jSeparator1);
        this.jMenuOption.setText("Overlap Setting");
        this.jMenuOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrchViewer.this.jMenuOptionActionPerformed(evt);
            }
        });
        this.jMenuAnalyze.add(this.jMenuOption);
        this.jMenuBarMain.add(this.jMenuAnalyze);
        this.setJMenuBar(this.jMenuBarMain);
        this.pack();
    }

    private void jSpinnerMinimumStateChanged(ChangeEvent evt) {
        this.drawOverlap();
    }

    private void jSpinnerVerticalStateChanged(ChangeEvent evt) {
        this.checkMaxOfMinOverlap();
        this.drawOverlap();
    }

    private void jSpinnerHorizontalStateChanged(ChangeEvent evt) {
        this.checkMaxOfMinOverlap();
        this.drawOverlap();
    }

    private void jMenuOptionActionPerformed(ActionEvent evt) {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        this.jDialogOption.setLocation(pointerInfo.getLocation());
        this.jDialogOption.setVisible(true);
        this.drawOverlap();
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void jMenuClearTableActionPerformed(ActionEvent evt) {
        this.jTableImages.clearContents();
    }

    private void jMenuSaveTableActionPerformed(ActionEvent evt) {
        if (!this.pickupThumbnailFromTable()) {
            return;
        }
        TableModel model = this.jTableImages.getModel();
        String[] args = new String[this.thumbnails.size() * 2 + 1];
        args[0] = this.rectThumbnailExist.height + "," + this.rectThumbnailExist.width;
        for (int i = 0; i < this.thumbnails.size(); ++i) {
            Point p = this.thumbnails.get(i);
            ImagePiece tn = (ImagePiece)model.getValueAt(p.y * 2 + 1, p.x * 2 + 1);
            args[i * 2 + 1] = p.x + "," + p.y;
            args[i * 2 + 2] = tn.getPath();
        }
        this.imageIO.writeStrings(args);
    }

    private void jMenuOpenTableActionPerformed(ActionEvent evt) {
        this.createLoadImageTask();
        this.timer.schedule(this.taskLoadImage, 100L);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.jDialogSetTable.setVisible(false);
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int row = (Integer)this.jSpinnerRowNumber.getValue();
        int column = (Integer)this.jSpinnerColumnNumber.getValue();
        this.jTableImages.setTable(row * 2 + 1, column * 2 + 1);
        this.jDialogSetTable.setVisible(false);
    }

    private void jMenuSetTableActionPerformed(ActionEvent evt) {
        this.jSpinnerColumnNumber.setValue(this.jTableImages.getColumnCount() / 2);
        this.jSpinnerRowNumber.setValue(this.jTableImages.getRowCount() / 2);
        this.jDialogSetTable.setVisible(true);
    }

    private void jMenuAnalyzeStartActionPerformed(ActionEvent evt) {
        this.createAnalyzeTask();
        this.timer.schedule(this.taskAnalyze, 50L);
    }

    private void jMenuDeleteImageActionPerformed(ActionEvent evt) {
        int rowIndex = this.jTableImages.getSelectedRow();
        int columnIndex = this.jTableImages.getSelectedColumn();
        this.jTableImages.setValueAt(null, rowIndex, columnIndex);
    }

    private void jMenuRemoveRowActionPerformed(ActionEvent evt) {
        int rowIndex;
        if (3 < this.jTableImages.getRowCount() && (rowIndex = this.jTableImages.getSelectedRow()) % 2 == 1) {
            DefaultTableModel model = (DefaultTableModel)this.jTableImages.getModel();
            model.removeRow(rowIndex);
            model.removeRow(rowIndex);
        }
        this.jTableImages.setDragging(false);
    }

    private void jMenuRemoveColumnActionPerformed(ActionEvent evt) {
        int columnIndex;
        if (3 < this.jTableImages.getColumnCount() && (columnIndex = this.jTableImages.getSelectedColumn()) % 2 == 1) {
            this.jTableImages.removeColumnAndData(columnIndex, 2);
        }
        this.jTableImages.setDragging(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new OrchViewer().setVisible(true);
            }
        });
    }
}

