/*
 * ImageTableCellRenderer.java
 *
 * Created on 2004/12/19, 17:08
 */

package orch;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/02/15)
 */
public class ImageTableCellRenderer extends JLabel implements TableCellRenderer{
	private Color lightBlue = new Color(240,240,255);
	private Color blue = new Color(180,180,255);
	private Color lightGray = new Color(235,235,235);	
	
	public ImageTableCellRenderer(){
		super();
		setOpaque(true);
		setHorizontalAlignment(SwingConstants.CENTER);
		setVerticalAlignment(SwingConstants.CENTER);
	}
	
	public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
		boolean canvasRow = (row%2==0)?false:true;
		boolean canvasColumn = (column%2==0)?false:true;
		
		setIcon(null);
		if (!canvasRow && !canvasColumn){// the cells which do NOT accept drop
			setBackground(Color.black);
		}else{
			JDropableTable dropTable = (JDropableTable)jTable;			
			if(canvasRow && canvasColumn){// canvas cells
				if(isSelected && dropTable.isDragging()){
					setBackground(lightGray);
				}else{
					setBackground(Color.white);
				}
				if (obj!=null){
					ImagePiece imagePiece = (ImagePiece)obj;
					setIcon(new ImageIcon(imagePiece.getThumbnail()));
				}
			}else{// border cells
				if(isSelected && dropTable.isDragging()){
					setBackground(blue);
				}else{
					setBackground(lightBlue);
				}
			}
		}
		
		return this;
	}
	
}
