/*
 * SearchPoint.java
 *
 * Created on 2005/01/25, 12:31
 */

package orch;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import sos.graphics.SOSGraphics;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/02/15)
 */
public class SearchPoint implements SOSGraphics{
	static private Color COLOR_ORANGE = new Color(255,0,128,64);
	
	private Point location;
	private double saturatedFitness;
	private boolean searched;
	
	private Rectangle intersectRect;
	private int intersectRectSize;
	
	/** Creates a new instance of SearchPoint */
	public SearchPoint(int x, int y) {
		location = new Point(x,y);
		setSaturatedFitness(-1.0);
	}
	
	public SearchPoint(Point location){
		this.location = location;
		setSaturatedFitness(-1.0);
	}
	
	public void setIntersectRect(Rectangle rect1, Rectangle rect2){
		rect2.setLocation(location);
		intersectRect = (Rectangle)rect1.intersection(rect2);
		intersectRectSize = intersectRect.width*intersectRect.height;
	}
	
	public void setIntersectRect(Rectangle rect){
		intersectRect = rect;
		intersectRectSize = intersectRect.width*intersectRect.height;
	}
	
	public Rectangle getIntersectRect(){
		return intersectRect;
	}
	
	public int getRectSize(){
		return intersectRectSize;
	}
	
	public Point getLocation(){
		return location;
	}
	
	public boolean isSaturated() {
		return (0.0<=getSaturatedFitness())?true:false;
	}
	
	public double getSaturatedFitness() {
		return saturatedFitness;
	}
	
	public void setSaturatedFitness(double saturatedFitness) {
		this.saturatedFitness = saturatedFitness;
	}
	
	public boolean isSearched() {
		return searched;
	}
	
	public void setSearched(boolean searched) {
		this.searched = searched;
	}
	
	public void draw(java.awt.Graphics g) {
		Graphics2D g2d = (Graphics2D)g;
		g2d.setColor(COLOR_ORANGE);
		g2d.fill(intersectRect);
	}
	
}
