/*
 * basicMatching.java
 *
 * Created on 2005/01/31, 0:54
 */

package orch.plugin;

import java.awt.Rectangle;
import java.util.ArrayList;
import orch.ImagePiece;
import orch.SearchPoint;
import sos.util.SortDouble;
import orch.Matching;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/02/15)
 */
public class BasicMatching extends Matching{
	
	protected Rectangle getSearchBounds(ImagePiece ipUnmove, ImagePiece ipMove, boolean isHorizontal){
		boolean reverseUnion = (ipUnmove.getIndex()<ipMove.getIndex())?false:true;
		
		Rectangle rect = ipUnmove.getBounds();
		Rectangle result = new Rectangle();
		
		double overlapRatio = 0.75;
		int range;
		if (isHorizontal){
			range = (int)(rect.height*overlapRatio);
			if (reverseUnion){
				result.setLocation(rect.x-rect.width, rect.y-range);
			}else{
				result.setLocation(rect.x+rect.width/2, rect.y-range);
			}
			result.setSize(rect.width-rect.width/2, range*2);
		}else{
			range = (int)(rect.width*overlapRatio);
			if (reverseUnion){
				result.setLocation(rect.x-range, rect.y-rect.height);
			}else{
				result.setLocation(rect.x-range, rect.y+rect.height/2);
			}
			result.setSize(range*2, rect.height-rect.height/2);
		}
		
		return result;
	}
	
	protected void matchThreeImage(ImagePiece ipUnmove, ImagePiece ipMove, ImagePiece ipSub, boolean isHorizontal){
		
		SearchPoint[][] points = getSearchPoints(ipUnmove.getBounds(),ipMove.getBounds(), ipSub.getBounds());
		SearchPoint[] pointsMain = points[0];
		SearchPoint[] pointsSub = points[1];
		double[] fitnesses = new double[pointsMain.length];
		double currentFitness = 0.0;
		int step = 64;
		do{
			
			for (int i=0; i<fitnesses.length; i++){
				if (!pauseFlag){
					currentFitness = calcFitness(ipUnmove, ipMove, pointsMain[i], step);
					double ratioPre = 0.5;
					//double ratioPre = 1.0*pointsMain[i].getRectSize()/(pointsMain[i].getRectSize()+pointsSub[i].getRectSize());
					fitnesses[i] = ratioPre*currentFitness+(1-ratioPre)*calcFitness(ipSub, ipMove, pointsSub[i],step);
				}else{
					break;
				}
			}
			
			SortDouble sd = new SortDouble(fitnesses);
			matchedBounds.setLocation(pointsMain[sd.getOrder(0)].getLocation());
			drawRects(ipUnmove,ipMove,ipSub, pointsMain[sd.getOrder(0)],pointsSub[sd.getOrder(0)]);
			
			pointsMain = sortSearchPoints(sd,pointsMain);
			pointsSub = sortSearchPoints(sd,pointsSub);
			fitnesses = new double[pointsMain.length];
			step *= 2;
			
		}while(1<fitnesses.length && !pauseFlag);
	}
	
	protected void matchTwoImage(ImagePiece ipUnmove, ImagePiece ipMove, boolean isHorizontal){
		
		SearchPoint[] pointsMain = getSearchPoints(ipUnmove.getBounds(),ipMove.getBounds());
		double[] fitnesses = new double[pointsMain.length];
		int step = 64;
		do{
			for (int i=0; i<fitnesses.length; i++){
				fitnesses[i] = calcFitness(ipUnmove,ipMove, pointsMain[i],step);
			}
			
			SortDouble sd = new SortDouble(fitnesses);
			matchedBounds.setLocation(pointsMain[sd.getOrder(0)].getLocation());
			drawRects(ipUnmove,ipMove,null,pointsMain[sd.getOrder(0)],null);
			
			pointsMain = sortSearchPoints(sd,pointsMain);
			fitnesses = new double[pointsMain.length];
			step *= 2;
		}while(1<fitnesses.length);
	}
	
	private SearchPoint[] getSearchPoints(Rectangle rect1, Rectangle rect2){
		ArrayList<SearchPoint> tempList = new ArrayList<SearchPoint>(searchBounds.width*searchBounds.height);
		for (int y=searchBounds.y; y<searchBounds.y+searchBounds.height; y++){
			for (int x=searchBounds.x; x<searchBounds.x+searchBounds.width; x++){
				rect2.setLocation(x,y);
				Rectangle intersectRect = (Rectangle)rect1.intersection(rect2);
				if (0<intersectRect.width*intersectRect.height){
					SearchPoint searchPoint = new SearchPoint(x,y);
					searchPoint.setIntersectRect(intersectRect);
					tempList.add(searchPoint);
				}
			}
		}
		tempList.toArray();
		SearchPoint[] result = new SearchPoint[tempList.size()];
		for (int i=0; i<result.length; i++){
			result[i] = tempList.get(i);
		}
		
		return result;
	}
	
	private SearchPoint[][] getSearchPoints(Rectangle rect1, Rectangle rect2, Rectangle rect3){
		SearchPoint[] tempList1 = new SearchPoint[searchBounds.width*searchBounds.height];
		SearchPoint[] tempList2 = new SearchPoint[searchBounds.width*searchBounds.height];
		
		int count = 0;
		for (int y=searchBounds.y; y<searchBounds.y+searchBounds.height; y++){
			for (int x=searchBounds.x; x<searchBounds.x+searchBounds.width; x++){
				rect2.setLocation(x,y);
				Rectangle intersectRect1 = (Rectangle)rect1.intersection(rect2);
				rect2.setLocation(x,y);
				Rectangle intersectRect2 = (Rectangle)rect3.intersection(rect2);
				if (0<intersectRect1.width*intersectRect1.height*intersectRect2.width*intersectRect2.height){
					SearchPoint searchPoint1 = new SearchPoint(x,y);
					searchPoint1.setIntersectRect(intersectRect1);
					
					SearchPoint searchPoint2 = new SearchPoint(searchPoint1.getLocation());
					searchPoint2.setIntersectRect(intersectRect2);
					
					tempList1[count] = searchPoint1;
					tempList2[count] = searchPoint2;
					count ++;
				}
			}
		}
		SearchPoint[][] result = new SearchPoint[2][count];
		for (int i=0; i<count; i++){
			result[0][i] = tempList1[i];
			result[1][i] = tempList2[i];
		}
		
		return result;
	}
	
	private SearchPoint[] sortSearchPoints(SortDouble sd, SearchPoint[] points){
		SearchPoint[] result = new SearchPoint[points.length/4];
		for (int i=0; i<result.length; i++){
			int index = sd.getOrder(i);
			result[i] = points[index];
		}
		
		return result;
	}
	
	private double calcFitness(ImagePiece ipFixed, ImagePiece ipFloppy, SearchPoint searchPoint, int step){
		
		if (searchPoint.isSaturated()){
			return searchPoint.getSaturatedFitness();
		}
		
		Rectangle interRect = searchPoint.getIntersectRect();
		Rectangle rectFixed = ipFixed.getBounds();
		Rectangle rectFloppy = ipFloppy.getBounds();
		int[] grayFixed = ipFixed.getPixelsData();
		int[] grayFloppy = ipFloppy.getPixelsData();
		rectFloppy.setLocation(searchPoint.getLocation());
		int sum = 0;
		int count = 0;
		int offStart1 = (interRect.x-rectFixed.x)+(interRect.y-rectFixed.y)*rectFixed.width;
		int offStart2 = (interRect.x-rectFloppy.x)+(interRect.y-rectFloppy.y)*rectFloppy.width;
		int off1,off2;
		
		int linearStep = searchPoint.getRectSize()/step;
		if (linearStep<1){
			linearStep = 1;
		}
		for (int i=0; i<searchPoint.getRectSize(); i+=linearStep){
			int x = interRect.x+i%interRect.width;
			int y = interRect.y+i/interRect.width;
			off1 = x-rectFixed.x+(y-rectFixed.y)*rectFixed.width;
			off2 = x-rectFloppy.x+(y-rectFloppy.y)*rectFloppy.width;
			sum += Math.abs(grayFixed[off1]-grayFloppy[off2]);
			count++;
		}
		double result = 1.0*sum/count;
		if (linearStep==1){
			searchPoint.setSaturatedFitness(result);
		}
		
		return result;
	}
	
}
