/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sowba.dtd2java.dtd;

import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.sowba.dtd2java.dtd.ElementObject;

public class ContextObject {
    private Map<String, ElementObject> m_elemmap = new LinkedHashMap<String, ElementObject>();
    private String m_factoryName;
    private Map<String, String> m_keymap = new LinkedHashMap<String, String>();
    private String m_packageName;

    public void addElement(String name, ElementObject elem) {
        this.m_elemmap.put(name, elem);
    }

    public void addKey(String elementName, String keyAttributeName) {
        this.m_keymap.put(elementName, keyAttributeName);
    }

    public ElementObject createElementObject(String name) {
        ElementObject elem = new ElementObject(name);
        String key = this.getKeyAttributeName(name);
        if (key != null) {
            elem.setKeyAttributeName(key);
        }
        return elem;
    }

    public ElementObject getElement(String name) {
        ElementObject o = this.m_elemmap.get(name);
        if (o instanceof ElementObject) {
            return o;
        }
        ElementObject newobj = this.createElementObject(name);
        this.addElement(name, newobj);
        return newobj;
    }

    public ElementObject[] getElements() {
        ElementObject[] elements = new ElementObject[this.m_elemmap.size()];
        this.m_elemmap.values().toArray(elements);
        return elements;
    }

    public String getFactoryName() {
        return this.m_factoryName;
    }

    public String getKeyAttributeName(String elementName) {
        return this.m_keymap.get(elementName);
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public boolean isKeyAttribute(String elementName, String attributeName) {
        String o = this.m_keymap.get(elementName);
        if (o == null) {
            return false;
        }
        return o.equalsIgnoreCase(attributeName);
    }

    public void setFactoryName(String factoryName) {
        this.m_factoryName = factoryName;
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
    }
}

